% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat.cor.R
\name{stat.cor}
\alias{stat.cor}
\title{Correlation test on permuted data.}
\usage{
stat.cor(ant, var1, var2, method = "pearson", progress = TRUE)
}
\arguments{
\item{ant}{an ant data object originating from permutations}

\item{var1}{an integer or string indicating the column in the data frames that corresponds to the first variable to correlate. This variable must be numerical.}

\item{var2}{an integer or string indicating the column in the data frames that corresponds to the second variable to correlate.This variable must be numerical.}

\item{method}{a string vector indicating which type of correlation to perform:
\itemize{
\item 'pearson' for pearson correlation
\item 'kendall' for kendall correlation
\item 'spearman' for spearman correlation
}}

\item{progress}{a boolean indicating the visualization of the permutation process.}
}
\value{
a vector of 3 elements: the t statistic, the degree of freedom, and the estimate.
}
\description{
This function is the first step in the process to create a correlation test in permuted data. For more details about correlation tests, see R documentation.
}
\details{
Performs correlations tests in a data frame and extracts the t statistic.
}
\examples{
t=met.strength(sim.m,sim.df,1) # Computing network metric
t=perm.net.nl(t,labels='age',rf=NULL,nperm=10,progress=FALSE) # Node label permutations
r.c=stat.cor(t,'age','strength',progress=FALSE) # Permuted correlation test
}
\references{
D. J. Best & D. E. Roberts (1975), Algorithm AS 89: The Upper Tail Probabilities of Spearman's rho. Applied Statistics, 24, 377-379.

Myles Hollander & Douglas A. Wolfe (1973), Nonparametric Statistical Methods. New York: John Wiley & Sons. Pages 185-194 (Kendall and Spearman tests).
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
