% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perm.net.links.R
\name{perm.net.lk}
\alias{perm.net.lk}
\title{Matrix links permutations}
\usage{
perm.net.lk(M, sym = FALSE, erase.diag = TRUE, nperm, progress = TRUE)
}
\arguments{
\item{M}{a square adjacency matrix or a list of square adjacency matrices.}

\item{sym}{if \emph{true} it vectorizes the lower triangle only .}

\item{erase.diag}{if \emph{true} it erases the diagonal of the matrix.}

\item{nperm}{number of permutations wanted.}

\item{progress}{a boolean indicating if the permutation process must be visible.}
}
\value{
list of square matrices of length nperm + 1.
}
\description{
Permutes matrix links.
}
\details{
Edge permutations can be used to create random networks based on the observed network. Such permutation method is useful when analysing patterns of interaction such as assortativity.
}
\examples{
t=perm.net.lk(sim.m, sym = FALSE, erase.diag = TRUE, nperm=10, progress=TRUE)
}
\references{
Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
