% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.ci.R
\name{met.ci}
\alias{met.ci}
\title{Centralisation index}
\usage{
met.ci(M, df = NULL)
}
\arguments{
\item{M}{a square adjacency matrix, or a list of square adjacency matrices, or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{df}{a data frame of same length as the input matrix or a list of data frames if argument \emph{M} is a list of matrices or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}
}
\value{
#' \itemize{
\item a double representing the centralisation index of the network if argument \emph{M} is a square matrix.
\item A list of doubles if argument \emph{M} is a list of matrices and if argument \emph{df} is \emph{NULL}. Each double represents the centralisation index of the corresponding matrix of the list.
\item A list of arguments \emph{df} with a new column of network centralisation index if argument\emph{df} is not \emph{NULL} and if argument \emph{M} is a list of matrices. The name of the column is adapted according to arguments values \emph{binary} and \emph{sym}.
\item A list of arguments \emph{df} with a new column of network centralisation index if argument \emph{df} is not \emph{NULL}, if argument \emph{M} is an output from ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk} for multiple matrices permutations, and if argument \emph{df} is a list of data frames of same length as argument \emph{M}.
}
}
\description{
Computes network Centralisation index
}
\details{
Centralisation index of a network is based on eigenvector centrality.
}
\examples{
met.ci(sim.m)
}
\references{
Pasquaretta, C., Leve, M., Claidiere, N., Van De Waal, E., Whiten, A., MacIntosh, A. J., ... & Crofoot, M. C. (2014). Social networks in primates: smart and tolerant species have more efficient networks. Scientific reports, 4, 7600.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez
}
