% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assoc.gfi.R
\name{assoc.gfi}
\alias{assoc.gfi}
\title{Generalized affiliation index}
\usage{
assoc.gfi(M1, M2, fr = TRUE, sym = FALSE, erase.diag = TRUE, index = "sri")
}
\arguments{
\item{M1}{a square adjacency matrix representing individual interactions or associations. In the latter case, associations must be in the form of a gbi.}

\item{M2}{a square adjacency matrix representing individual values of confounding factors.}

\item{fr}{if \emph{true}, it considers the argument M1 as an adjacency matrix representing interaction frequencies between individuals.
Otherwise, it considers the argument M1 as an adjacency matrix representing associations between individuals.}

\item{sym}{if \emph{true}, it considers the argument M1 as an adjacency matrix representing symmetric interactions/associations.}

\item{erase.diag}{if \emph{true}, it omits the diagonal of the matrix.}

\item{index}{a string indicating the association index to compute:
\itemize{
\item 'sri' for Simple ratio index: \eqn{x/x+yAB+yA+yB}
\item 'hw' for Half-weight index: \eqn{x/x+yAB+1/2(yA+yB)}
\item 'sr' for Square root index:\eqn{x/sqr((x+yAB+yA)(x+yAB+yB))}
}}
}
\value{
a square adjacency matrix representing the generalized affiliation index between individuals.
}
\description{
Computes generalized affiliation indices based on a matrix of interactions or associations and a confounding factor.
}
\details{
Generalized affiliation indices allow to control for individual associations by a given confounding factor (such as temporal or spatial overlaps, gregariousness, social unit membership, kinship...).
The principle is to perform a Generalized Linear Regression (GLR) on both matrices (one representing individual interactions/associations and the other one representing the confounding factor)
and to use GLR residuals as association indices. For an adjacency matrix representing individual interactions, the GLR belongs to the Poisson family. For an adjacency matrix representing individual associations, the GLR belongs to the Binomial family.
High positive values suggest strong associations between two individuals and negative values suggest avoidance between two individuals.
}
\examples{
assoc.gfi(sim.gbi,sim.gbi.att, fr = FALSE)
}
\references{
Whitehead, H., & James, R. (2015). Generalized affiliation indices extract affiliations from social network data. Methods in Ecology and Evolution, 6(7), 836-844.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
