% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xlr_integer.R
\name{xlr_integer}
\alias{xlr_integer}
\alias{is_xlr_integer}
\alias{as_xlr_integer}
\title{\code{xlr_integer} vector}
\usage{
xlr_integer(x = integer(), style = xlr_format_numeric())

is_xlr_integer(x)

as_xlr_integer(x, style = xlr_format_numeric())
}
\arguments{
\item{x}{A numeric vector
\itemize{
\item For \code{xlr_integer()}: A numeric vector
\item For \code{is_xlr_integer()}: An object to test
\item For \code{as_xlr_integer()} : a vector
}}

\item{style}{Additional styling options for the vector. See \link{xlr_format_numeric} for more details.}
}
\value{
An S3 vector of class \code{xlr_integer}
}
\description{
This creates an integer vector that will be printed neatly and can easily be
exported to \code{Excel} using it's native format.You can
convert a vector back to its base type with \code{\link[=as_base_r]{as_base_r()}}.
}
\details{
Internally, \code{xlr_integer} uses \code{vec_cast} to convert numeric types
to integers. Anything that \code{vec_cast} can handle so can \code{xlr_integer}. Read
more about casting at \link[vctrs]{vec_cast}.
}
\examples{
library(xlr)
# Create a variable to represent an integer
x <- xlr_integer(2)
# This will print nicely
x
# You can change the styling, which affects how it looks when we save it as an
# `Excel` document
x <- xlr_integer(x, style = xlr_format(font_size = 9, font_colour = "red"))
x
# We can also define a vector of integers
y <- xlr_integer(c(1,2,3))
y
# You can convert existing data to a integer using dplyr verbs
# It formats large numbers nicely
df <- data.frame(col_1 = c(1:100*100))
df |>
  dplyr::mutate(col_pct = as_xlr_integer(col_1))
# You can use as_xlr_integer to convert a string in a integer
df <- data.frame(col_str = c("12","13","14"))
# now we can convert the string to a integer(), internally it uses the same
# logic as as.integer()
df |>
  dplyr::mutate(col_percent = as_xlr_integer(col_str))
}
\seealso{
\code{\link[=xlr_vector]{xlr_vector()}}, \code{\link[=xlr_percent]{xlr_percent()}}, \code{\link[=xlr_numeric]{xlr_numeric()}}
}
