% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_prdseries.R
\name{show_prdseries}
\alias{show_prdseries}
\title{Plot predictions for GAMs over time series}
\usage{
show_prdseries(
  mod,
  ylab,
  yromit = NULL,
  alpha = 0.7,
  base_size = 11,
  xlim = NULL,
  ylim = NULL,
  col = "brown",
  minomit = 8
)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{ylab}{chr string for y-axis label}

\item{yromit}{optional numeric vector for years to omit from the plot, see details}

\item{alpha}{numeric from 0 to 1 indicating line transparency}

\item{base_size}{numeric indicating base font size, passed to \code{\link[ggplot2]{theme_bw}}}

\item{xlim}{optional numeric vector of length two for x-axis limits}

\item{ylim}{optional numeric vector of length two for y-axis limits}

\item{col}{optional chr string for line color}

\item{minomit}{numeric indicating number of observations in the observed data to exclude in the predicted series for a given year if provided to \code{yromit}}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Plot predictions for GAMs over time series
}
\details{
The optional \code{yromit} vector can be used to omit years from the plot. This may be preferred if the predicted values from the model deviate substantially from other years likely due to missing data.

The \code{yromit} argument behaves differently for this function compared to others because of a mismatch in the timestep for the predicted time series and the observed data. The function will attempt to find "bookends" in the observed data that match with the predicted time series for each year in \code{yromit}.  For example, if there is a gap in the observed data that spans multiple years and a single year value is included with \code{yromit} that is within the gap, the predicted time series will not be shown for the entire gap in the observed data even if additional years within the gap were not provided to \code{yromit}.
 
Entire years where observed data are present can also be removed from the predicted time series if they exceed a minimum number of observations defined by \code{minomit}. For example, if a year has at least 8 observations and \code{yromit} includes that year, the predicted time series for that entire year will be removed.
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl')

mod <- anlz_gam(tomod, trans = 'log10')

show_prdseries(mod, ylab = 'Chlorophyll-a (ug/L)')
}
\concept{show}
