% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STMF.R
\name{read_stmf}
\alias{read_stmf}
\title{Read Short-Term Mortality Fluctuations data from the Human Mortality Database}
\usage{
read_stmf(country)
}
\arguments{
\item{country}{Country name or country code as specified by the HMD. For instance, Australian
data can be obtained using \code{country = "Australia"} or \code{country = "AUS"}.}
}
\value{
A \code{vital} object combining the downloaded data.
}
\description{
\code{read_stmf} reads weekly mortality data from the Short-term Mortality Fluctuations (STMF)
series available in the Human Mortality Database (HMD) \url{https://www.mortality.org/Data/STMF}),
and constructs a \code{vital} object suitable for use in other functions.
}
\examples{
\dontrun{
norway <- read_stmf(country = "NOR")
}


}
\author{
Sixian Tang
}
