% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescaleVector.R
\name{rescaleVector}
\alias{rescaleVector}
\title{Rescales a vector within given bounds.}
\usage{
rescaleVector(
  x = rnorm(100),
  new.min = 0,
  new.max = 100,
  integer = FALSE
  )
}
\arguments{
\item{x}{numeric vector to be rescaled.}

\item{new.min}{numeric, new minimum value for \code{x}. Default is 0.}

\item{new.max}{numeric, new maximum value for \code{x}. Default is 100.}

\item{integer}{boolean, if TRUE, output vector is returned as vector of integers. Default is FALSE.}
}
\value{
A vector of the same length as \code{x} rescaled between \code{output.min} and \code{output.max}.
}
\description{
Takes a numeric vector \code{x} and rescales it within the values given by \code{new.min} and \code{new.max}.
}
\examples{
#generating example data
x = rnorm(100)

#as float
x.float <- rescaleVector(
  x = x,
  new.min = 0,
  new.max = 100,
  integer = FALSE
  )

#as integer
x.integer <- rescaleVector(
  x = x,
  new.min = 0,
  new.max = 100,
  integer = TRUE
  )

}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
