% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametersCheck.R
\name{parametersCheck}
\alias{parametersCheck}
\title{Plots main simulation parameters.}
\usage{
parametersCheck(
  parameters,
  species = "all",
  driver.A = NULL,
  driver.B = NULL,
  drivers = NULL,
  filename = NULL
  )
}
\arguments{
\item{parameters}{the parameters dataframe.}

\item{species}{if "all" or "ALL", all species in "parameters" are plotted. It also accepts a vector of numbers representing the rows of the selected species, or a vector of names of the selected species.}

\item{driver.A}{numeric vector with driver values.}

\item{driver.B}{numeric vector with driver values.}

\item{drivers}{dataframe with drivers}

\item{filename}{character string, filename of the output pdf.}
}
\value{
ggplot object.
}
\description{
Plots the environmental niche, fecundity, growth curve, and maturity age, of each virtual taxa in a parameters dataframe for \code{\link{simulatePopulation}}, to help the user in making choices while adjusting them.
}
\details{
Priority is given to drivers introduced through the \code{drivers} argument.

The function prints the plot, can save it to a pdf file if \code{filename} is provided, and returns a ggplot object.
}
\examples{
\donttest{
#getting data
data(parameters)
data(drivers)

#plotting parameters
parametersCheck(
 parameters = parameters,
 drivers = drivers
 )
}

}
\seealso{
\code{\link{parametersDataframe}}, \code{\link{fixParametersTypes}}
}
\author{
Blas M. Benito  <blasbenito@gmail.com>
}
