% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directional_derivative3d.R
\name{directional_derivative3d}
\alias{directional_derivative3d}
\title{Directional derivative in any dimension, with optional 2D visualization}
\usage{
directional_derivative3d(
  f,
  x0,
  v,
  h = 1e-06,
  plot = FALSE,
  x_window = 2,
  y_window = 2,
  n_s = 180,
  n_r = 50,
  show_strip = TRUE,
  strip_colorscale = "Blues",
  strip_opacity = 0.3,
  show_surface_grid = TRUE,
  surface_grid_color = "rgba(60,80,200,0.25)",
  surface_grid_width = 1,
  curve_line = list(color = "red", width = 1),
  point_marker = list(color = "black", size = 3, symbol = "circle"),
  u_line = list(color = "black", width = 1),
  w_line = list(color = "black", width = 0.5),
  t_range = c(-2, 2),
  scene = list(aspectmode = "data", xaxis = list(title = "x"), yaxis = list(title = "y"),
    zaxis = list(title = "z")),
  bg = list(paper = "white", plot = "white"),
  tol = 1e-12
)
}
\arguments{
\item{f}{A function returning a numeric scalar. It may be defined either
as \code{f(x, y, ...)} with several numeric arguments, or as a function
of a numeric vector, \code{f(x_vec)}.}

\item{x0}{Numeric vector giving the evaluation point. Its length
determines the dimension of the problem.}

\item{v}{Numeric vector giving the direction along which the directional
derivative is computed. Must be nonzero and have the same length as
\code{x0}.}

\item{h}{Numeric step size used for centered finite-difference
approximations.}

\item{plot}{Logical; if \code{TRUE} and \code{length(x0) == 2}, displays a
3D visualization of the local surface using \pkg{plotly}.}

\item{x_window, y_window}{Numeric half-widths defining the size of the
rectangular window around the evaluation point in the 2D case.}

\item{n_s}{Integer giving the number of samples along the direction line
in the 2D visualization.}

\item{n_r}{Integer giving the number of samples across the strip in the
2D visualization.}

\item{show_strip}{Logical; if \code{TRUE}, draws a surface strip around
the evaluation point.}

\item{strip_colorscale}{Character string specifying a \pkg{plotly}
colorscale for the strip.}

\item{strip_opacity}{Numeric value between 0 and 1 determining the
opacity of the strip.}

\item{show_surface_grid}{Logical; if \code{TRUE}, overlays a grid onto
the surface strip.}

\item{surface_grid_color}{Character string giving the grid line color.}

\item{surface_grid_width}{Numeric value giving the grid line width.}

\item{curve_line, point_marker, u_line, w_line}{Lists with \pkg{plotly}
style options for the directional curve, evaluation point, and auxiliary
lines.}

\item{t_range}{Numeric vector of length two giving the parameter range
for the directional curve in the 2D visualization.}

\item{scene, bg}{Lists specifying 3D scene and background options when
plotting.}

\item{tol}{Numeric tolerance used for detecting numerical degeneracies.}
}
\value{
A list containing:
\describe{
\item{\code{D}}{The directional derivative at \code{x0} along the
normalized direction.}
\item{\code{v_hat}}{The normalized direction vector.}
\item{\code{fx}, \code{fy}}{Centered partial derivatives in two
dimensions (only returned when \code{length(x0) == 2}).}
\item{\code{fig}}{A \pkg{plotly} visualization when \code{plot = TRUE},
otherwise \code{NULL}.}
}
}
\description{
Computes a numerical directional derivative of a multivariate function
at a given point, along a specified direction. The derivative is
approximated using centered finite differences. If the dimension is two
and \code{plot = TRUE}, the function displays a local visualization of
the surface defined by \code{z = f(x, y)}, including the evaluation point,
the direction, and the curve traced along that direction.
}
\details{
The function accepts two types of input for the function \code{f}:
\itemize{
\item a function of several numeric arguments, for example
\code{f(x, y, z, ...)}, or
\item a function that takes a single numeric vector, such as
\code{f(x_vec)}.
}

At the evaluation point \code{x0}, the function:
\itemize{
\item normalizes the direction vector \code{v} to obtain a unit
direction,
\item computes forward and backward perturbations along this unit
direction,
\item evaluates the function at those perturbed points,
\item estimates the directional derivative using a centered
finite-difference formula.
}

In two dimensions, if \code{plot = TRUE}, the function builds a small
rectangular window around \code{x0} and evaluates the function over a
fine grid to produce a strip of the surface. It then overlays:
\itemize{
\item the base point,
\item the selected direction,
\item the trajectory of the directional curve,
\item (optionally) a surface grid and other plot elements.
}
}
\examples{
# General n-dimensional usage:
f3 <- function(x, y, z) x^2 + y^2 + z
directional_derivative3d(f3, x0 = c(1, 0, 0), v = c(1, 1, 0))

# Two-dimensional example without plotting (fast, no plotly required):
f2 <- function(x, y) x^2 + y^2
directional_derivative3d(f2, x0 = c(0, 0), v = c(1, 2), plot = FALSE)

}
