% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel.R
\name{parallel-operators}
\alias{parallel-operators}
\alias{vec_pany}
\alias{vec_pall}
\title{Parallel \code{any()} and \code{all()}}
\usage{
vec_pany(
  ...,
  .missing = NA,
  .size = NULL,
  .arg = "",
  .error_call = current_env()
)

vec_pall(
  ...,
  .missing = NA,
  .size = NULL,
  .arg = "",
  .error_call = current_env()
)
}
\arguments{
\item{...}{Logical vectors of equal size.}

\item{.missing}{Value to use when a missing value is encountered. One of:
\itemize{
\item \code{NA} to propagate missing values. With this, missings are treated the
same way as \code{|} or \code{&}.
\item \code{FALSE} to treat missing values as \code{FALSE}.
\item \code{TRUE} to treat missing values as \code{TRUE}.
}}

\item{.size}{An optional output size. Only useful to specify if it is possible
for no inputs to be provided.}

\item{.arg}{Argument name used in error messages.}

\item{.error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}
}
\value{
A logical vector the same size as the vectors in \code{...}.
}
\description{
These functions are variants of \code{\link[=any]{any()}} and \code{\link[=all]{all()}} that work in parallel on
multiple inputs at once. They work similarly to how \code{\link[=pmin]{pmin()}} and \code{\link[=pmax]{pmax()}} are
parallel variants of \code{\link[=min]{min()}} and \code{\link[=max]{max()}}.
}
\details{
\code{vec_pany()} and \code{vec_pall()} are consistent with \code{\link[=any]{any()}} and \code{\link[=all]{all()}} when
there are no inputs to process in parallel:
\itemize{
\item \code{any()} returns \code{FALSE} with no inputs. Similarly, \code{vec_pany(.size = 1)}
returns \code{FALSE}.
\item \code{all()} returns \code{TRUE} with no inputs. Similarly, \code{vec_pall(.size = 1)}
returns \code{TRUE}.
}
}
\examples{
a <- c(TRUE, TRUE, TRUE, FALSE, FALSE, FALSE, NA, NA, NA)
b <- c(TRUE, FALSE, NA, TRUE, FALSE, NA, TRUE, FALSE, NA)

# Default behavior treats missings like `|` does
vec_pany(a, b)
a | b

# Default behavior treats missings like `&` does
vec_pall(a, b)
a & b

# Remove missings from the computation, like `na_rm = TRUE`
vec_pany(a, b, .missing = FALSE)
(a & !is.na(a)) | (b & !is.na(b))

vec_pall(a, b, .missing = TRUE)
(a | is.na(a)) & (b | is.na(b))

# `vec_pall()` can be used to implement a `dplyr::filter()` style API
df <- data_frame(id = seq_along(a), a = a, b = b)

keep_rows <- function(x, ...) {
  vec_slice(x, vec_pall(..., .missing = FALSE))
}
drop_rows <- function(x, ...) {
  vec_slice(x, !vec_pall(..., .missing = FALSE))
}

# "Keep / Drop the rows when both a and b are TRUE"
# These form complements of one another, even with `NA`s.
keep_rows(df, a, b)
drop_rows(df, a, b)

# Same empty behavior as `any()` and `all()`
vec_pany(.size = 1)
any()

vec_pall(.size = 1)
all()
}
