% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vascr_export.R
\name{vascr_export_prism}
\alias{vascr_export_prism}
\title{Export a vascr dataframe}
\usage{
vascr_export_prism(
  data.df,
  filepath = tempfile("test_export", fileext = ".xlsx"),
  level = "experiments"
)
}
\arguments{
\item{data.df}{a vascr dataset to export}

\item{filepath}{Path to save the dataframe in}

\item{level}{Level of replication to export, defaults to experiments}
}
\value{
A dataframe in prism format, or writes to file if filepath specified
}
\description{
Export a vascr dataframe
}
\examples{
filepath = tempfile("test_export", fileext = ".xlsx")
to_export = growth.df \%>\% vascr_subset(unit = c("R", "Rb"), frequency = c(0,4000))
vascr_export_prism(to_export, filepath)

vascr_export_prism(to_export, filepath, level = "wells")

}
