% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track_speed.R
\name{track_speed}
\alias{track_speed}
\title{Track speed}
\usage{
track_speed(x, y, date)
}
\arguments{
\item{x}{longitude}

\item{y}{latitude}

\item{date}{date-time in POSIXct}
}
\value{
numeric vector of sequential distances in metres per second, see Details
}
\description{
Calculate speed (m/s) based on geodesic distance with longitude, latitude, date-time
input vectors. The unit of speed is metres per second.
}
\details{
By convention the first value is set to \code{NA} missing value, because the difference
applies to each sequential pair of locations.

To use this on multiple track ids, use a grouped data frame with tidyverse code like
\code{data \%>\% group_by(id) \%>\% mutate(speed = track_speed(lon, lat, date))}
}
\examples{
track_speed(trips0$x, trips0$y, trips0$date)[1:10]
}
