% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checktoxicity.R
\name{checktoxicity}
\alias{checktoxicity}
\title{Check for an effect}
\usage{
checktoxicity(
  dataset,
  Conc,
  Response,
  effect,
  type = c("relative", "absolute"),
  direction = c("below", "above"),
  reference_group = "0",
  target_group = NULL,
  list_obj = NULL,
  quiet = FALSE
)
}
\arguments{
\item{dataset}{A dataframe, containing the columns `Conc` and `Response`.}

\item{Conc}{Bare (unquoted) column name in `dataset` that groups the
`Response` variable.}

\item{Response}{Bare (unquoted) column name in `dataset` containing
the response variable.}

\item{effect}{Numeric. Dictates at the value beyond which observations
are flagged as toxic. This value can be further customized; see
see `type` and `direction`.}

\item{type}{Character. Indicates if `effect` is `"relative"` to
`reference group` or an `"absolute"` value. Defaults to relative.}

\item{direction}{Character. Indicates if an effect occurs `"below"` or
`"above"`. Defaults to below.}

\item{reference_group}{Label used for reference group in `Conc` column.
Defaults to 0.}

\item{target_group}{Optional. Limits the compairison to certain levels in
`Conc`.}

\item{list_obj}{Optional. List object used for integration with
[runtoxdrc()].}

\item{quiet}{Logical. Indicates if results should be hidden. Defaults
to FALSE.}
}
\value{
TRUE if the response variable exceeds a limit in either
 direction and FALSE otherwise. If `list_obj` is provided, returns this
 within a list as `list_obj$effect`.
}
\description{
`checktoxicity()` flags if the response variable exceeds a limit in
 either direction as evidence of an effect.
}
\examples{
checktoxicity(
 dataset = toxresult,
 Conc = Conc,
 Response = RFU,
 effect = 0.5
)

}
