\encoding{utf8}
\name{tost.sign.rank}
\alias{Equivalence signed rank tests}
\alias{tost.sign.rank}
\concept{Equivalence signed rank tests}
\concept{Two One-Sided Tests}
\title{Test for the distribution of paired or matched data being equivalent to one that is symmetrical & centered on zero}
\description{
 \loadmathjax
 Performs two one-sided approximate \emph{z} tests for equivalence between the distribution of paired differences and a distribution which is both symmetric and centered on zero.}
\usage{
tost.sign.rank(
  x, y, 
  eqv.type     = equivalence.types, 
  eqv.level    = 1, 
  upper        = NA,
  ccontinuity  = FALSE, 
  conf.level   = 0.95, 
  x.name       = "", 
  y.name       = "", 
  relevance    = TRUE)

equivalence.types
#c("delta", "epsilon")
}
\arguments{
 \item{x}{a (non-empty) numeric vector of data values.}
 \item{y}{a (non-empty) numeric vector of data values.}
 \item{eqv.type}{defines whether the equivalence interval will be defined in terms of \mjeqn{\varepsilon}{epsilon} or \mjeqn{\Delta}{Delta} (\code{"epsilon"}, or \code{"delta"}). These options change the way that \code{evq.level} is interpreted: when \code{"epsilon"} is specified, the \code{evq.level} is measured in units of the \emph{z} distribution, and when \code{"delta"} is specified, the \code{evq.level} is measured in the units of the absolute value of sums of signed ranks of paired differences; put another way \mjeqn{\varepsilon = \frac{\Delta}{\text{standard error}}}{epsilon = Delta/standard error}. Because units of absolute value of sums of signed ranks of paired differences is unlikely to be substantively meaningful, the default is \code{"epsilon"}. \cr \cr Defining tolerance in terms of \mjeqn{\varepsilon}{epsilon} means that it is not possible to reject any test for mean equivalence's \mjeqn{\text{H}_{0}^{-}}{Ho} if \mjeqn{\varepsilon \le z_{\alpha}}{epsilon <= the critical value of \emph{z} for a given alpha}. Because \mjeqn{\varepsilon = \frac{\Delta}{\text{standard error}}}{epsilon = Delta/standard error}, we can see that it is not possible to reject any \mjeqn{\text{H}_{0}^{-}}{Ho} if \mjeqn{\Delta \le \text{standard error} \times z_{\alpha}}{Delta <= the product of the standard error and critical value of \emph{z} for a given alpha}. \code{tost.sign.rank} reports when either of these conditions obtain.}
 \item{eqv.level}{defines the equivalence threshold for the tests depending on whether \code{eqv.type} is \code{"epsilon"} or \code{"delta"} (see above). Researchers are responsible for choosing meaningful values of \mjeqn{\varepsilon}{epsilon} or \mjeqn{\Delta}{Delta}. The default value is 1, which is not a useful value for either \code{eqv.type="delta"} or \code{eqv.type="epsilon"}.}
 \item{upper}{defines the upper equivalence threshold for the test, is assumed to be positive, and transforms the meaning of \code{eqv.level} to mean the \emph{lower} equivalence threshold for the test. Also, \code{eqv.level} is assumed to be a negative value. Taken together, these correspond to Schuirmann's (1987) asymmetric equivalence intervals. If \code{upper==abs(eqv.level)}, then \code{upper} will be ignored.}
 \item{ccontinuity}{calculates test statistics for both positivist and negativist tests using a continuity correction. For the positivist test the approximate statistic \mjeqn{z = \tfrac{\text{sgn}(T)\times(|T-\mu_{T}|-0.5)}{\sigma_{T}}}{z = (sgn(\emph{T})×|\emph{T} -- mu_\emph{T}| -- 0.5) ÷ sigma_\emph{T}}. \cr \cr For the negativist test using \mjeqn{\varepsilon}{epsilon} the approximate test statsitics are \mjeqn{z_1 = \varepsilon_{\text{u}} - z}{z_1 = epsilon_u -- \emph{z}}, and \mjeqn{z_2 = z - \varepsilon_{\text{l}}}{z_2 = \emph{z} -- epsilon_l} (where \mjeqn{z}{\emph{z}} is the continuity-corrected test statistic from the positivist test). \cr \cr For the negativist test using \mjeqn{\Delta}{Delta} approximate statistics are \mjeqn{z_1 = \tfrac{\Delta_{\text{u}} - [\text{sgn}(T)\times(|T-\mu_{T}|-0.5)]}{\sigma_{T}}}{z_1 = (Delta_u -- (sgn(\emph{T})×|\emph{T} -- mu_\emph{T}| -- 0.5)) ÷ sigma_\emph{T}} and \mjeqn{z_2 = \tfrac{[\text{sgn}(T)\times(|T-\mu_{T}|-0.5)]-\Delta_{\text{l}}}{\sigma_{T}}}{z_2 = ((sgn(\emph{T})×|\emph{T} -- mu_\emph{T}| -- 0.5) -- Delta_l) ÷ sigma_\emph{T}}.}
 \item{conf.level}{confidence level of the interval, and complement of the test's nominal type I error rate \mjeqn{\alpha}{alpha}.}
 \item{x.name}{specifies how the first variable will be labeled in the output. The default value of \code{x.name} is the variable name of \code{x}.}
 \item{y.name}{specifies how the second variable will be labeled in the output. The default value of \code{y.name} is the variable name of \code{y}.}
 \item{relevance}{reports results and inference for combined tests for difference and for equivalence for a specific \code{conf.level}, \code{eqv.type}, \code{eqv.level}, and, if used, \code{upper}. See the Remarks section more details on inference from combined tests.}
}
\details{\code{tost.sign.rank} tests the null hypothesis that the paired differences in measures are not symmetrically distributed and/or are not centered on the value of zero, and provides evidence for the distribution paired differences being equivalence to one that is symmetric and centered on zero. \code{tost.sign.rank} uses the \emph{z} approximation to the Wilcoxon matched-pairs signed-ranks test (Wilcoxon 1945) in a two one-sided tests approach (Schuirmann, 1987).

With respect to the signed-rank test, a negativist null hypothesis takes one of the following two forms depending on whether tolerance is defined in terms of \mjeqn{\Delta}{Delta} (equivalence expressed in the same units as the absolute value of sums of signed ranks) or in terms of \mjeqn{\varepsilon}{espilon} (equivalence expressed in the units of the \emph{z} distribution):

\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }|T - \mu_T| \ge \Delta}{&nbsp;&nbsp;Ho: |\emph{T} -- mu_\emph{T}| >= Delta},\cr
\emph{}\mjeqn{\phantom{22}}{ }where the equivalence interval ranges from \mjeqn{\left(T - \mu_T\right) - \Delta}{(\emph{T} -- mu_\emph{T}) -- Delta} to \mjeqn{\left(T - \mu_T\right) + \Delta}{(\emph{T} -- mu_\emph{T}) + Delta.} This translates directly into two one-sided null hypotheses:

\emph{}\mjeqn{\phantom{2222}\text{ H}_{01}^{-}\text{: }T - \mu_T \ge \Delta}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1: \emph{T} -- mu_\emph{T} >= Delta}, or\cr
\emph{}\mjeqn{\phantom{2222}\text{ H}_{02}^{-}\text{: }T - \mu_T \le -\Delta}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1: \emph{T} -- mu_\emph{T} <= Delta}.

--OR--

\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }|Z| \ge \varepsilon ,}{&nbsp;&nbsp;Ho: |Z| >= epsilon,}\cr
\emph{}\mjeqn{\phantom{22}}{ }where the equivalence interval ranges from \mjeqn{-\varepsilon}{--epsilon} to \mjeqn{\varepsilon}{epsilon}. This also translates directly into two one-sided null hypotheses:

\emph{}\mjeqn{\phantom{2222}\text{H}_{01}^{-}\text{: }Z \ge \varepsilon}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1: Z >= epsilon}; or\cr
\emph{}\mjeqn{\phantom{2222}\text{H}_{02}^{-}\text{: }Z \le -\varepsilon}{&nbsp;&nbsp;&nbsp;&nbsp;Ho2: Z <= --epsilon}.

When an asymmetric equivalence interval is defined using the \code{upper} option the general negativist null hypothesis becomes:

\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }T - \mu_T \le \Delta_{\text{l}}}{&nbsp;&nbsp;Ho: \emph{T} -- mu_\emph{T} <= Delta_lower}, or \mjeqn{T - \mu_T \ge \Delta_{\text{u}}}{Ho: \emph{T} -- mu_\emph{T} >= Delta_upper}\cr
\emph{}\mjeqn{\phantom{22}}{ }where the equivalence interval ranges from \mjeqn{\left(T - \mu_T\right) + \Delta_{\text{l}}}{(\emph{T} -- mu_\emph{T}) + Delta_lower} to \mjeqn{\left(T - \mu_T\right) + \Delta_{\text{u}}}{(\emph{T} -- mu_\emph{T}) + Delta_upper}. This also translates directly into two one-sided null hypotheses:

\emph{}\mjeqn{\phantom{2222}\text{H}_{01}^{-}\text{: }T - \mu_T \ge \Delta_{\text{u}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1: \emph{T} -- mu_\emph{T} >= Delta_upper}; or\cr
\emph{}\mjeqn{\phantom{2222}\text{H}_{02}^{-}\text{: }T - \mu_T \le \Delta_{\text{l}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho2: \emph{T} -- mu_\emph{T} <= Delta_lower}.

--OR--

\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }Z \le \varepsilon_{\text{l}}}{&nbsp;&nbsp;Ho: Z <= epsilon_lower}, or \mjeqn{Z \ge \varepsilon_{\text{u}}}{Z >= epsilon_upper}, with:

\emph{}\mjeqn{\phantom{2222}\text{H}_{01}^{-}\text{: }Z \ge \varepsilon_{\text{u}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1: Z >= epsilon_upper}; or\cr
\emph{}\mjeqn{\phantom{2222}\text{H}_{02}^{-}\text{: }Z \le \varepsilon_{\text{l}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho2: Z <= epsilon_lower}.\cr
 
NOTE: the appropriate level of \mjeqn{\alpha = (1 - }{alpha = (1 -- }\code{conf.level}\mjeqn{)}{)} is precisely the same as in the corresponding two-sided test for mean difference, so that, for example, if one wishes to make a type I error \%1 of the time, one simply conducts both of the one-sided tests of \mjeqn{\text{H}_{01}^{-}}{Ho1} and \mjeqn{\text{H}_{02}^{-}}{Ho2} by comparing the resulting p-value to 0.01 (Wellek, 2010).

\subsection{Remarks}{Following Tryon and Lewis (2008), when rejection decisions from both tests for difference (e.g., \mjeqn{\text{H}_{0}^{+}\text{: }T- \mu_T = 0}{positivist Ho: \emph{T} -- mu_\emph{T} = 0} or ) and tests for equivalence (e.g., either \mjeqn{\text{H}_{0}^{-}\text{: }|T- \mu_T| \ge \Delta}{negativist Ho: |\emph{T} -- mu_\emph{T}| >= Delta}, or \mjeqn{\text{H}_{0}^{-}\text{: }|Z| \ge \varepsilon}{negativist Ho: |Z| >= epsilon}) are combined, there are four possible interpretations for a given \mjeqn{\alpha}{alpha} and \mjeqn{\Delta}{Delta} or \mjeqn{\varepsilon}{epsilon}:

\enumerate{
\item One may reject \mjeqn{\text{H}_{0}^{+}}{the positivist Ho}, but fail to reject \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and conclude that there is a \bold{relevant difference} between the distribution of paired differences and a distribution which is both symmetric and centered on zero which is at least as large as \mjeqn{\varepsilon}{epsilon} or \mjeqn{\Delta}{Delta}.

\item One may fail to reject \mjeqn{\text{H}_{0}^{+}}{the positivist Ho}, but reject \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and conclude that there is \bold{equivalence} between the distribution of paired differences and a distribution which is both symmetric and centered on zero within the equivalence range (i.e. defined by \mjeqn{\varepsilon}{epsilon} or \mjeqn{\Delta}{Delta}).

\item One may reject both \mjeqn{\text{H}_{0}^{+}}{the positivist Ho} and \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and conclude that there is a \bold{trivial difference} between the distribution of paired differences and a distribution which is both symmetric and centered on zero which lies within the equivalence range (i.e. defined by \mjeqn{\varepsilon}{epsilon} or \mjeqn{\Delta}{Delta}).

\item One may fail to reject both \mjeqn{\text{H}_{0}^{+}}{the positivist Ho} and \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and draw an \bold{indeterminate} conclusion, because the data are underpowered to detect either difference or equivalence.
}
}
}
\value{
\code{tost.sign.rank} returns:
 \item{statistics}{a vector of the \emph{z} statistics for the two one-sided tests; if \code{relevance=TRUE}, these are followed by the value of the \emph{z} statistic for the postivist test for difference.}
 \item{p.values}{a vector of \emph{p} values for the \emph{z} tests.}
 \item{signed_rank_sums}{a vector containing the absolute value of positive and negative rank sums, and the signed rank sum expected under the positivist null hypothesis.}
 \item{sample_size}{a scalar containing the sample size.}
 \item{counts}{a vector containing the number of negative comparisons, number of positive comparisons, and number of tied comparisons.}
 \item{var_adj}{a scalar containing the adjusted variance under the postivist null hypothesis.}
 \item{threshold}{a scalar containing the equivalence threshold when \code{eqv.type="delta"} and \code{upper=NA}. A vector containing the asymmetric equivalence thresholds \code{upper}, and \code{eqv.level} when \code{eqv.type="delta"}. A scalar containing the equivalence threshold when \code{eqv.type="epsilon"} and \code{upper=NA}. A vector containing the asymmetric equivalence thresholds \code{upper}, and \code{eqv.level} when \code{eqv.type="epsilon"}.}
 \item{conclusion}{a string containing the relevance test conclusion when \code{relevance=TRUE}.}
 }
\author{
Alexis Dinno (\email{alexis.dinno@pdx.edu})

Please contact me with any questions, bug reports or suggestions for improvement. Fixing bugs will be facilitated by sending along:
\enumerate{
\item a copy of the data (de-labeled or anonymized is fine),\cr
\item a copy of the command syntax used, and\cr
help \item a copy of the exact output of the command.\cr
}
Much appreciation to Mick McVeety for troubleshooting the translation of my Stata \bold{tost} package to R.
\subsection{Suggested citation}{Dinno, A. 2025. \bold{tost.sign.rank}: Test for the distribution of paired or matched data being equivalent to one that is symmetrical & centered on zero. In: \bold{tost.suite} R software package.}
}
\references{

Schuirmann, D. A. (1987) \href{https://pubmed.ncbi.nlm.nih.gov/3450848/}{A comparison of the two one-sided tests procedure and the power approach for assessing the equivalence of average bioavailability}. \emph{Journal of Pharmacokinetics and Biopharmaceutics}. \bold{15}, 657--680.

Snedecor, G. W., and W. G. Cochran. (1989) \href{https://www.wiley.com/en-us/Statistical\%20Methods,\%208th\%20Edition-p-9780813815619}{\emph{Statistical Methods}}. 8th ed. Ames, IA: Iowa State University Press.

Tryon, W. W., and Lewis, C. (2008) \href{https://pubmed.ncbi.nlm.nih.gov/18778155/}{An inferential confidence interval method of establishing statistical equivalence that corrects Tryon's (2001) reduction factor}. \emph{Psychological Methods}. \bold{13}, 272--277.

Wellek, S. (2010) \href{https://www.routledge.com/Testing-Statistical-Hypotheses-of-Equivalence-and-Noninferiority/Wellek/p/book/9781439808184}{\emph{Testing Statistical Hypotheses of Equivalence and Noninferiority}}, Second edition. Chapman and Hall/CRC Press. p. 31.

Wilcoxon, F. (1945) \href{http://www.jstor.org/stable/3001968}{Individual comparisons by ranking methods}. \emph{Biometrics Bulletin}. \bold{1}, 80--83.
}
\seealso{
 \code{\link{SignRank}}, \code{\link{tost.rank.sum}}, \code{\link{wilcox.test}}.
}
\examples{
require("webuse")

#Setup
webuse("fuel")

# Perform sign-rank relevance test between mpg1 and mpg2; equivalence
# interval is +/- 1.5 sd beyond the critical value of Z for alpha = 0.05.
tost.sign.rank(
  fuel$mpg1, 
  fuel$mpg2, 
  eqv.type="epsilon", 
  eqv.level=qnorm(.95)+1.5, 
  relevance=TRUE)

# Same example, but using an asymmetric equivalence interval and continuity
# correction.  The lower end of the equivalence interval = qnorm(.95)+1.5
# = 3.144854 meaning equivalence must lay no more than 1.5 sd beyond the
# critical value of Z for alpha = 0.05.  The upper end of the equivalence
# interval = qnorm(.95)+1 = 2.644854 meaning equivalence must lay
# no more than 1 sd beyond the critical value of Z for alpha = 0.05.
tost.sign.rank(
  fuel$mpg1, 
  fuel$mpg2, 
  eqv.type="epsilon", 
  eqv.level=qnorm(.95)+1.5, 
  upper=qnorm(.95)+1, 
  ccontinuity=TRUE, 
  relevance=TRUE)
}
\keyword{htest}
\keyword{stats}
