\encoding{utf8}
\name{tost.pri}
\alias{Immediate one- and two-sample z tests for proportion equivalence}
\alias{tost.pri}
\concept{z tests for proportion equivalence}
\concept{Two One-Sided Tests}
\title{Immediate one- and two-sample \emph{z} tests for proportion equivalence}
\description{
  \loadmathjax
  Immediately performs two one-sided \emph{z} tests for proportion equivalence}
\usage{
tost.pri(
    n1 = NA, obs1 = NA, n2 = NA, obs2 = NA, count = FALSE,
    eqv.type     = equivalence.types, 
    eqv.level    = 1, 
    upper        = NA,
    ccontinuity  = continuity.correction.methods, 
    conf.level   = 0.95, 
    x.name       = "x",
    y.name       = "y", 
    relevance    = TRUE)

equivalence.types
#c("delta", "epsilon")

continuity.correction.methods
#c
}
\arguments{
 \item{n1}{required group 1 sample size.}
 \item{obs1}{required group 1 sample proportion if \code{count=FALSE}. If \code{count=TRUE}, then \code{obs1} is interpreted as the count of successes in the first sample (i.e. as the numerator of the group 1 sample proportion).}
 \item{n2}{an optional group 2 sample size. If \code{n2} is a positive integer, then \code{tost.pri} performs a two-sample test.}
 \item{obs2}{required true proportion (\mjeqn{p_0}{p0}) for the one-sample test when \code{n2=NA}.  If \code{n2=NA} and \code{count=FALSE}, \code{obs2} is the group 2 sample proportion.  If \code{n2=NA} and \code{count=TRUE}, \code{obs2} is still interpreted as the true population proportion (\mjeqn{p_0}{\emph{p}0}) when \code{n2=NA}.}
 \item{count}{optionally indicates whether \code{n1} and \code{obs1} (but not \code{obs2}) are both to be treated as counts for a one-sample test, or, whether \code{n1}, \code{obs1},\code{n2}, and \code{obs2} are to be treated as counts for a two-sample test.}
 \item{eqv.type}{defines whether the equivalence interval will be defined in terms of \mjeqn{\Delta}{\U0394} or \mjeqn{\varepsilon}{\U03B5} (\code{"delta"}, or \code{"epsilon"}). These options change the way that \code{evq.level} is interpreted: when \code{"delta"} is specified, the \code{evq.level} is expressed in the same units as proportion of the variable(s) being tested, and when \code{"epsilon"} is specified, the \code{evq.level} is expressed in units of the \emph{z} distribution; put another way \mjeqn{\varepsilon = \frac{\Delta}{\text{standard error}}}{\U03B5 = \U0394/standard error}. The default is \code{"delta"}.\cr \cr Defining tolerance in terms of \mjeqn{\varepsilon}{\U03B5} means that it is not possible to reject any test for mean equivalence's \mjeqn{\text{H}_{0}^{-}}{Ho} if \mjeqn{\varepsilon \le z_{\nu,\alpha}}{\U03B5 \U2264 the critical value of \emph{z} for a given \mjeqn{\alpha}{\U03B1} and degrees of freedom}. Because \mjeqn{\varepsilon = \frac{\Delta}{\text{standard error}}}{\U03B5 = \U0394/standard error}, we can see that it is not possible to reject any \mjeqn{\text{H}_{0}^{-}}{Ho} if \mjeqn{\Delta \le \text{standard error} \times z_{\nu,\alpha}}{\U0394 \U2264 the product of the standard error and critical value of \emph{z} for a given \mjeqn{\alpha}{\U03B1} and degrees of freedom}. \code{tost.pri} reports when either of these conditions obtain.}
 \item{eqv.level}{defines the equivalence threshold for the tests depending on whether \code{eqv.type} is \code{"delta"} or \code{"epsilon"} (see above).  Researchers are responsible for choosing meaningful values of \mjeqn{\Delta}{\U0394} or \mjeqn{\varepsilon}{\U03B5}. The default value is 1, which is not a useful value for either \code{eqv.type="delta"} or \code{eqv.type="epsilon"}.}
 \item{upper}{defines the upper equivalence threshold for the test, is assumed to be positive, and transforms the meaning of \code{eqv.level} to mean the \emph{lower} equivalence threshold for the test.  Also, \code{eqv.level} is assumed to be a negative value. Taken together, these correspond to Schuirmann's (1987) asymmetric equivalence intervals. If \code{upper==abs(eqv.level)}, then \code{upper} will be ignored.}
 \item{conf.level}{confidence level of the interval, and complement of the test's nominal type I error rate \mjeqn{\alpha}{\U03B1}.}
 \item{x.name}{specifies how the first group will be labeled in the output. The default value of \code{x.name} is \code{"x"}.}
 \item{y.name}{specifies how the second group will be labeled in the output. The default value of \code{y.name} is \code{"y"}}
 \item{ccontinuity}{calculates test statistics for both positivist and negativist tests using a continuity correction. The default is \code{"none"}, users may select a Yates continuity correction using the \code{"yates"} option, or the Hauck-Anderson continuity correction using the \code{"ha"} option. Note that the Hauck-Anderson continuity correction (only available for the two-sample test) also adjusts the standard error of the proportion used to calculate test statistics.}
 \item{relevance}{reports results and inference for combined tests for difference and for equivalence for a specific \code{conf.level}, \code{eqv.type}, \code{eqv.level}, and, if used, \code{upper}.  See the Remarks section more details on inference from combined tests.}
}
\details{Immediate commands perfom tests given summary statistics, rather than given data. \code{tost.pri} tests for the equivalence of proportions within a symmetric equivalence interval defined by \code{eqvtype} and \code{eqvlevel} (or within an asymmetric interval when adding the \code{upper} argument) using a two one-sided \emph{z} tests (TOST) approach (Schuirmann, 1987). Typically "positivist" null hypotheses are framed from an assumption of a lack of difference between two quantities, and reject this assumption only with sufficient evidence. When performing tests for equivalence, one frames a null hypothesis with the assumption that two quantities are different within an equivalence interval defined by some chosen level of tolerance.
  
With respect to an unpaired \emph{z} test, an equivalence null hypothesis takes one of the following two forms depending on whether equivalence is defined in terms of \mjeqn{\Delta}{\U0394} (equivalence expressed in the same units as the proportions of the two variables) or in terms of \mjeqn{\varepsilon}{\U03B5} (equivalence expressed in the units of the \emph{z} distribution with the given degrees of freedom):

\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }|p_{x} - p_y| \ge \Delta}{&nbsp;&nbsp;Ho: |p_x -- p_y| \U2265 \U0394},\cr

\emph{}\mjeqn{\phantom{22}}{  }where the equivalence interval ranges from \mjeqn{\left(p_x - p_y\right) - \Delta}{(p_x -- p_y)-\U0394} to \mjeqn{\left(p_x - p_y\right) + \Delta}{(p_x -- p_y)+\U0394}. This translates directly into two one-sided null hypotheses:

\emph{}\mjeqn{\phantom{2222}\text{  H}_{01}^{-}\text{: }p_{x} - p_y \ge \Delta}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1: p_x -- p_y \U2265 \U0394}, or\cr
\emph{}\mjeqn{\phantom{2222}\text{  H}_{02}^{-}\text{: }p_{x} - p_y \le -\Delta}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1: p_x -- p_y \U2264 \U0394}.

--OR--

\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }|Z| \ge \varepsilon ,}{&nbsp;&nbsp;Ho: |Z| \U2265 \U03B5,}\cr

\emph{}\mjeqn{\phantom{22}}{  }where the equivalence interval ranges from \mjeqn{-\varepsilon}{--\U03B5} to \mjeqn{\varepsilon}{\U03B5}. This also translates directly into two one-sided null hypotheses:

\emph{}\mjeqn{\phantom{2222}\text{H}_{01}^{-}\text{: }Z \ge \varepsilon}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1: Z \U2265 \U03B5}; or\cr
\emph{}\mjeqn{\phantom{2222}\text{H}_{02}^{-}\text{: }Z \le -\varepsilon}{&nbsp;&nbsp;&nbsp;&nbsp;Ho2: Z \U2264 --\U03B5}.

When an asymmetric equivalence interval is defined using the \code{upper} option the general negativist null hypothesis becomes:

\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }p_{x} - p_y \le \Delta_{\text{lower}}}{&nbsp;&nbsp;Ho: p_x -- p_y \U2264 \U0394_lower}, or \mjeqn{p_{x} - p_y \ge \Delta_{\text{upper}}}{Ho: p_x -- p_y \U2265 \U0394_upper}\cr

\emph{}\mjeqn{\phantom{22}}{  }where the equivalence interval ranges from \mjeqn{\left(p_x - p_y\right) + \Delta_{\text{lower}}}{(p_x -- p_y) + \U0394_lower} to \mjeqn{\left(p_x - p_y\right) + \Delta_{\text{upper}}}{(p_x -- p_y) + \U0394_upper}.  This also translates directly into two one-sided null hypotheses:

\emph{}\mjeqn{\phantom{2222}\text{H}_{01}^{-}\text{: }p_x - p_y \ge \Delta_{\text{upper}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1: p_x -- p_y \U2265 \U0394_upper}; or\cr
\emph{}\mjeqn{\phantom{2222}\text{H}_{02}^{-}\text{: }p_x - p_y \le \Delta_{\text{lower}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho2: p_x -- p_y \U2264 \U0394_lower}.

--OR--

\emph{}\mjeqn{\phantom{22}\text{H}_{0}^{-}\text{: }Z \le \varepsilon_{\text{lower}}}{&nbsp;&nbsp;Ho: Z \U2264 \U03B5_lower}, or \mjeqn{Z \ge \varepsilon_{\text{upper}}}{Z \U2265 \U03B5_upper}, with:

\emph{}\mjeqn{\phantom{2222}\text{H}_{01}^{-}\text{: }Z \ge \varepsilon_{\text{upper}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho1: Z \U2265 \U03B5_upper}; or\cr
\emph{}\mjeqn{\phantom{2222}\text{H}_{02}^{-}\text{: }Z \le \varepsilon_{\text{lower}}}{&nbsp;&nbsp;&nbsp;&nbsp;Ho2: Z \U2264 \U03B5_lower}.\cr
 
NOTE: the appropriate level of \mjeqn{\alpha = (1 - }{\U03B1 =  (1 -- }\code{conf.level}\mjeqn{)}{)} is precisely the same as in the corresponding two-sided test for mean difference, so that, for example, if one wishes to make a type I error \%1 of the time, one simply conducts both of the one-sided tests of \mjeqn{\text{H}_{01}^{-}}{Ho1} and \mjeqn{\text{H}_{02}^{-}}{Ho2} by comparing the resulting p-value to 0.01 (Tryon and Lewis, 2008; Wellek, 2010).

\subsection{Remarks}{As described by Tryon and Lewis (2008), when rejection decisions from both tests for difference (e.g., \mjeqn{\text{H}_{0}^{+}\text{: }p_{x}- p_{y} = 0}{positivist Ho: p_x -- p_y = 0} or ) and tests for equivalence (e.g., either \mjeqn{\text{H}_{0}^{-}\text{: }|p_{x}- p_{y}| \ge \Delta}{negativist Ho: |p_x -- p_y| \U2265 \U0394}, or \mjeqn{\text{H}_{0}^{-}\text{: }|Z| \ge \varepsilon}{negativist Ho: |Z| \U2265 \U03B5}) are combined, there are four possible interpretations for a given \mjeqn{\alpha}{\U03B1} and \mjeqn{\Delta}{\U0394} or \mjeqn{\varepsilon}{\U03B5}:

\enumerate{
\item One may reject \mjeqn{\text{H}_{0}^{+}}{the positivist Ho}, but fail to reject \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and conclude that there is a \bold{relevant difference} in proportions at least as large as \mjeqn{\Delta}{\U0394} or \mjeqn{\varepsilon}{\U03B5}.

\item One may fail to reject \mjeqn{\text{H}_{0}^{+}}{the positivist Ho}, but reject \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and conclude that there is \bold{equivalence} in proportions within the equivalence range (i.e. defined by \mjeqn{\Delta}{\U0394} or \mjeqn{\varepsilon}{\U03B5}).

\item One may reject both \mjeqn{\text{H}_{0}^{+}}{the positivist Ho} and \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and conclude that there is a \bold{trivial difference} in proportions which lies within the equivalence range (i.e. defined by \mjeqn{\Delta}{\U0394} or \mjeqn{\varepsilon}{\U03B5}).

\item One may fail to reject both \mjeqn{\text{H}_{0}^{+}}{the positivist Ho} and \mjeqn{\text{H}_{0}^{-}}{the negativist Ho}, and draw an \bold{indeterminate} conclusion, because the data are underpowered to detect either difference or equivalence.
}
}
}
\value{
\code{tost.pri} returns:
 \item{statistics}{a vector of the \emph{z} statistics for the two one-sided tests; if \code{relevance=TRUE}, these are followed by the value of the \emph{z} statistic for the postivist test for difference.}
 \item{p.values}{a vector of \emph{p} values for the \emph{z} tests.}
 \item{proportion}{a scalar estimate of the sample proportion in the one-sample test. A vector of the proportions in both groups, as well as the estimate of the proportion under the null hypothesis in the two-sample test.}
 \item{sample_size}{a scalar containing the sample size of the one-sample test. A vector of the sample size in both groups, as well as the combined sample size in the two-sample test.}
 \item{threshold}{a scalar containing the equivalence threshold when \code{eqv.type="delta"} and \code{upper=NA}. A vector containing the asymmetric equivalence thresholds \code{upper}, and \code{eqv.level} when \code{eqv.type="delta"}. A scalar containing the equivalence threshold when \code{eqv.type="epsilon"} and \code{upper=NA}. A vector containing the asymmetric equivalence thresholds \code{upper}, and \code{eqv.level} when \code{eqv.type="epsilon"}.}
 \item{conclusion}{a string containing the relevance test conclusion when \code{relevance=TRUE}.}
 }
\author{
Alexis Dinno (\email{alexis.dinno@pdx.edu})

Please contact me with any questions, bug reports or suggestions for improvement.  Fixing bugs will be facilitated by sending along:
\enumerate{
\item a copy of the data (de-labeled or anonymized is fine),\cr
\item a copy of the command syntax used, and\cr
\item a copy of the exact output of the command.\cr
}
I am endebted to my winter 2013 and fall 2023 students for their inspiration. Much appreciation to Mick McVeety for troubleshooting the translation of my Stata \bold{tost} package to R.
\subsection{Suggested citation}{Dinno, A.  2025.  \bold{tost.pri}: Mean-equivalence \emph{z} tests.  In: \bold{tost.suite} R software package.}
}
\references{

Hauck, W.  W.  and S.  Anderson. (1984)  \href{https://pubmed.ncbi.nlm.nih.gov/6747820/}{A new statistical procedure for testing equivalence in two-group comparative bioavailability trials}. \emph{Journal of Pharmacokinetics and Pharmacodynamics}. \bold{12}, 83--91.

Hauck, W.  W.  and Anderson, S. (1986)  \href{https://www.jstor.org/stable/2684618}{A comparison of large-sample confidence interval methods for the difference of two binomial probabilities}. \emph{The American Statistician}. \bold{40}, 318--322.

Schuirmann, D.  A.  (1987) \href{https://pubmed.ncbi.nlm.nih.gov/3450848/}{A comparison of the two one-sided tests procedure and the power approach for assessing the equivalence of average bioavailability}. \emph{Journal of Pharmacokinetics and Biopharmaceutics}. \bold{15}, 657--680.

Tryon, W. W., and C. Lewis. (2008) \href{https://pubmed.ncbi.nlm.nih.gov/18778155/}{An inferential confidence interval method of establishing statistical equivalence that corrects Tryon's (2001) reduction factor}. \emph{Psychological Methods}. \bold{13}, 272--277

Yates, F.  (1934)  \href{https://www.jstor.org/stable/2983604}{Contingency tables involving small numbers and the \mjeqn{\chi^2}{chi-squared} test}.  \emph{Supplement to the Journal of the Royal Statistical Society}. \bold{1}, 217--235.

Wellek, S.  (2010)  \href{https://www.routledge.com/Testing-Statistical-Hypotheses-of-Equivalence-and-Noninferiority/Wellek/p/book/9781439808184}{\emph{Testing Statistical Hypotheses of Equivalence and Noninferiority}}, second edition. Chapman and Hall/CRC Press. p. 31}
\seealso{
  \code{\link{prop.test}}, \code{\link{tost.pr}}.
}
\examples{
# Immediate form of one-sample z test for proportion equivalence
# Note warning about value of Delta!
tost.pri(
    n1=50, 
    obs1=.52, 
    obs2=.70, 
    eqv.type="delta", 
    eqv.level=.1,
    relevance=FALSE)

# First two numbers are counts; equivalence interval is +/- 1 sd
# beyond the critical value of Z for alpha = 0.05
tost.pri(
    n1=30, 
    obs1=4, 
    obs2=.70, 
    eqv.type="epsilon", 
    eqv.level=qnorm(.95)+1, 
    count=TRUE, 
    conf.level=0.95,
    relevance=TRUE)

# Immediate form of two-sample z test for proportion equivalence using an
# example from Tu 1997, p 276, and incorporating the Hauck and Anderson
# continuity correction from that same example.
tost.pri(
    n1=101, 
    obs1=.40594059, 
    n2=100, 
    obs2=.49, 
    eqv.type="delta", 
    eqv.level=.2,
    ccontinuity="ha",
    relevance=FALSE)

# The same example, but all numbers are counts
tost.pri(
    n1=101, 
    obs1=41, 
    n2=100, 
    obs2=49, 
    eqv.type="delta", 
    eqv.level=.2,
    count=TRUE,
    ccontinuity="ha",
    relevance=FALSE)
}
\keyword{htest}
\keyword{stats}
