% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_core.R
\name{read_toon}
\alias{read_toon}
\title{Read TOON from file}
\usage{
read_toon(
  file,
  strict = TRUE,
  simplify = TRUE,
  allow_comments = TRUE,
  allow_duplicate_keys = TRUE,
  encoding = "UTF-8"
)
}
\arguments{
\item{file}{Character scalar. Path to TOON file.}

\item{strict}{Logical. If TRUE (default), enforce strict TOON syntax.}

\item{simplify}{Logical. If TRUE (default), simplify homogeneous arrays to
atomic vectors.}

\item{allow_comments}{Logical. If TRUE (default), allow # and // comments.}

\item{allow_duplicate_keys}{Logical. If TRUE (default), allow duplicate keys
in objects.}

\item{encoding}{Character. File encoding (default "UTF-8").}
}
\value{
R object representing the parsed TOON data.
}
\description{
Read TOON from file
}
\examples{
# Read from file
\dontrun{
data <- read_toon("config.toon")
}

}
