% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuning.R
\name{tl_tune_grid}
\alias{tl_tune_grid}
\title{Tune hyperparameters for a model using grid search}
\usage{
tl_tune_grid(
  data,
  formula,
  method,
  param_grid,
  folds = 5,
  metric = NULL,
  maximize = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame containing the training data}

\item{formula}{A formula specifying the model}

\item{method}{The modeling method to tune}

\item{param_grid}{A named list of parameter values to tune}

\item{folds}{Number of cross-validation folds}

\item{metric}{Metric to optimize}

\item{maximize}{Logical; whether to maximize (TRUE) or minimize (FALSE) the metric}

\item{verbose}{Logical; whether to print progress}

\item{...}{Additional arguments passed to tl_model}
}
\value{
A list with the best model and tuning results
}
\description{
Tune hyperparameters for a model using grid search
}
