% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter-tap.R
\name{filter_tap}
\alias{filter_tap}
\alias{filter_out_tap}
\title{Operation-Aware Filter Taps}
\usage{
filter_tap(
  .data,
  ...,
  .trail = NULL,
  .label = NULL,
  .stat = NULL,
  .quiet = FALSE,
  .warn_threshold = NULL
)

filter_out_tap(
  .data,
  ...,
  .trail = NULL,
  .label = NULL,
  .stat = NULL,
  .quiet = FALSE,
  .warn_threshold = NULL
)
}
\arguments{
\item{.data}{A data.frame or tibble.}

\item{...}{Filter conditions, evaluated in the context of \code{.data} using
tidy evaluation (same as \code{\link[dplyr:filter]{dplyr::filter()}}).}

\item{.trail}{An \code{\link[=audit_trail]{audit_trail()}} object, or \code{NULL} (the default). When
\code{NULL}, behavior depends on diagnostic arguments: if none are provided,
a plain \code{dplyr::filter()} is performed; if \code{.stat}, \code{.warn_threshold}, or
\code{.quiet = TRUE} is provided, delegates to \code{\link[=filter_keep]{filter_keep()}} or
\code{\link[=filter_drop]{filter_drop()}}.}

\item{.label}{Optional character label for this snapshot. If \code{NULL},
auto-generated as \code{"filter_1"} etc.}

\item{.stat}{An unquoted column or expression to total, e.g., \code{amount},
\code{price * qty}. Reports the stat amount dropped and its share of the total.}

\item{.quiet}{Logical. If \code{TRUE}, suppress printing diagnostics (default
\code{FALSE}).}

\item{.warn_threshold}{Numeric between 0 and 1. If set and the proportion of
dropped rows exceeds this threshold, a warning is issued.}
}
\value{
The filtered data.frame or tibble.
}
\description{
Performs a diagnostic filter AND records filter diagnostics in an audit trail.
\code{filter_tap()} keeps matching rows (like \code{\link[dplyr:filter]{dplyr::filter()}}),
\code{filter_out_tap()} drops matching rows (the inverse).
}
\details{
When \code{.trail} is \code{NULL}:
\itemize{
\item No diagnostic args: plain \code{dplyr::filter()} / \code{dplyr::filter_out()}
\item Diagnostic args provided: delegates to \code{\link[=filter_keep]{filter_keep()}} /
\code{\link[=filter_drop]{filter_drop()}} (prints diagnostics but no trail recording)
\item \code{.label} provided: warns that label is ignored
}
}
\examples{
df <- data.frame(id = 1:10, amount = 1:10 * 100, flag = rep(c(TRUE, FALSE), 5))

# With trail
trail <- audit_trail("filter_example")
result <- df |>
  audit_tap(trail, "raw") |>
  filter_tap(amount > 300, .trail = trail, .label = "big_only")
print(trail)

# Inverse: drop matching rows
trail2 <- audit_trail("filter_out_example")
result2 <- df |>
  audit_tap(trail2, "raw") |>
  filter_out_tap(flag == FALSE, .trail = trail2, .label = "flagged_only")
print(trail2)

# Without trail (plain filter)
result3 <- filter_tap(df, amount > 300)

}
\seealso{
Other operation taps: 
\code{\link{join_tap}}
}
\concept{operation taps}
