% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-misc.R
\name{augment_standard_calendar_tbl}
\alias{augment_standard_calendar_tbl}
\title{Add Comprehensive Date-Based Attributes to a Data Frame}
\usage{
augment_standard_calendar_tbl(.data, .date)
}
\arguments{
\item{.data}{A data frame or tibble containing at least one date column.}

\item{.date}{A column containing \code{Date} values, passed using tidy-eval
(e.g., \code{{{ date_col }}}).}
}
\value{
A tibble containing the original data along with all generated
date-based attributes.
}
\description{
This function takes a data frame and a date column and generates a wide set of
derived date attributes. These include start/end dates for year, quarter,
month, and week; day-of-week indicators; completed and remaining days in each
time unit; and additional convenience variables such as weekend indicators.

It is designed for time-based feature engineering and is useful in reporting,
forecasting, time-series modeling, and data enrichment workflows.
}
\details{
The function creates the following groups of attributes:

\strong{1. Start and end dates}
\itemize{
\item \code{year_start_date}, \code{year_end_date}
\item \code{quarter_start_date}, \code{quarter_end_date}
\item \code{month_start_date}, \code{month_end_date}
\item \code{week_start_date}, \code{week_end_date}
}

\strong{2. Day-of-week fields}
\itemize{
\item \code{day_of_week} – numeric day of the week (1–7)
\item \code{day_of_week_label} – ordered factor label (e.g., Mon, Tue, …)
}

\strong{3. Duration fields}
\itemize{
\item \code{days_in_year} – total days in the year interval
\item \code{days_in_quarter} – total days in the quarter interval
\item \code{days_in_month} – total days in the month
}

\strong{4. Completed/remaining days}
\itemize{
\item \code{days_complete_in_week}, \code{days_remaining_in_week}
\item \code{days_complete_in_month}, \code{days_remaining_in_month}
\item \code{days_complete_in_quarter}, \code{days_remaining_in_quarter}
\item \code{days_complete_in_year}, \code{days_remaining_in_year}
}

\strong{5. Miscellaneous}
\itemize{
\item \code{weekend_indicator} – equals 1 if Saturday or Sunday; otherwise 0
}

All date-derived fields ending in \verb{_date} are coerced to class \code{Date}.
}
\keyword{internal}
