% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_groups.R
\name{regroup}
\alias{regroup}
\title{regroup}
\usage{
regroup(
  filename,
  by = c("group", "recname"),
  extant = FALSE,
  group = TRUE,
  recname = NULL
)
}
\arguments{
\item{filename}{path where files or qs2/rds was exported, reconstruct object of class tabs or recvect object}

\item{by}{character varying, restructure by interconnected cluster ('group'), or by recname ('recname')}

\item{extant}{boolean, only currently existing shapes (TRUE) or all shapes (FALSE) are returned}

\item{group}{boolean, if TRUE, all shapes of the group will be returned.}

\item{recname}{character varying, by specifying a recname of interest, only shapes are returned for its group or recname}
}
\value{
list of regrouped shapes
}
\description{
regroup shapes by recname identifier or by interconnected cluster (group)
}
\examples{
#' # load data samples
sporades <- sporades()
topo <- sporades$topo
labs <- sporades$labs
correction <- sporades$correction
curve <- sporades$curve

# subset first and last period 
curve <- curve[[seq(1,dim(curve)[3],4)]]

# reconstruct
rec <- reconstruct(topo=topo,
                   region=labs,
                   curve=curve,
                   correction=correction,
                   reclabs='name'
                   )
                   
# regroup by group and return all shapes within group
recv <- regroup(filename=rec,
                by='group',
                group=TRUE,
                extant=FALSE)
# regroup by group and only return main group shape
recv <- regroup(filename=rec,
                by='group',
                group=FALSE,
                extant=FALSE)
# regroup by recname and return all shapes within group
recv <- regroup(filename=rec,
                by='recname',
                group=TRUE,
                extant=FALSE)
# regroup by group and only return main group shapes
recv <- regroup(filename=rec,
                by='recname',
                group=FALSE,
                extant=FALSE)
# regroup by recname and return all shapes within group
recv <- regroup(filename=rec,
                by='recname',
                recname='Nisída Ágios Geórgios',
                group=TRUE,
                extant=FALSE)
# regroup by group and only return main group shapes
recv <- regroup(filename=rec,
                by='recname',
                recname='Nisída Ágios Geórgios',
                group=FALSE,
                extant=FALSE)

# only extant (present day existing shapes)

# regroup by group and return all shapes within group
recv <- regroup(filename=rec,
                by='group',
                group=TRUE,
                extant=TRUE)
# regroup by group and only return main group shapes
recv <- regroup(filename=rec,
                by='group',
                group=FALSE,
                extant=TRUE)
# regroup by recname and return all shapes within group
recv <- regroup(filename=rec,
                by='recname',
                group=TRUE,
                extant=TRUE)
# regroup by group and only return main group shapes
recv <- regroup(filename=rec,
                by='recname',
                group=FALSE,
                extant=TRUE)
# regroup by recname and return all shapes within group
recv <- regroup(filename=rec,
                by='recname',
                recname='Nisída Ágios Geórgios',
                group=TRUE,
                extant=TRUE)
# regroup by group and only return main group shapes
recv <- regroup(filename=rec,
                by='recname',
                recname='Nisída Ágios Geórgios',
                group=FALSE,
                extant=TRUE)
                
}
\author{
Johannes De Groeve
}
