% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_groups.R
\name{get_groups}
\alias{get_groups}
\title{get_groups}
\usage{
get_groups(filename, unnest = TRUE, col = c("recnames", "refnames"))
}
\arguments{
\item{filename}{path where files or qs2/rds was exported, reconstruct object of class tabs or recvect object}

\item{unnest}{boolean, unnest groups to list all shape names and ids in a column}

\item{col}{character varying, which column to use to identify groups}
}
\value{
list with groups of interconnected shapes
}
\description{
get groups of interconnected shapes
}
\examples{
# load data samples
sporades <- sporades()
topo <- sporades$topo
labs <- sporades$labs
correction <- sporades$correction
curve <- sporades$curve

# subset first and last period 
curve <- curve[[c(1,dim(curve)[3])]]

# reconstruct
rec <- reconstruct(topo=topo,
                   region=labs,
                   curve=curve,
                   correction=correction,
                   reclabs='name'
                   )
groups <- get_groups(rec,unnest=FALSE)
ids <- get_groups(rec,unnest=TRUE)

}
\author{
Johannes De Groeve
}
