% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tablet.R
\name{escape_latex.default}
\alias{escape_latex.default}
\title{Escape Special Characters for Latex by Default}
\usage{
\method{escape_latex}{default}(x, secondary = TRUE, ...)
}
\arguments{
\item{x}{typically inherits character}

\item{secondary}{logical: whether secondary backslashes should be pre-doubled}

\item{...}{ignored}
}
\value{
latex
}
\description{
Escapes text characters that have special meaning in latex.
Adapted with gratitude from KableExtra internals.
I.e. inactivates material that otherwise looks like latex.
}
\details{
This function is used in \code{\link{as_kable.tablet}} in
preparation for a call to \code{\link[kableExtra]{kbl}}.
At kableExtra 1.3.4, sim_double_escape() only doubles
primary (leading) backslashes; the \code{secondary} argument
by default pre-doubles later backslashes to prevent
certain display errors.  Behavior may change if kableExtra changes.
}
\examples{
escape_latex('([#$\%&_{}])')
}
\seealso{
Other escape: 
\code{\link{escape_latex}()},
\code{\link{escape_latex.latex}()}
}
\concept{escape}
\keyword{internal}
