## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## -----------------------------------------------------------------------------
library(sumer)

## -----------------------------------------------------------------------------
info("lugal")

## -----------------------------------------------------------------------------
info("d-en-lil2")

## -----------------------------------------------------------------------------
# Transliteration -> Cuneiform
as.cuneiform("lugal-e")
as.cuneiform(c("d-en-lil2", "an-ki"))

# Transliteration -> Sign names
as.sign_name("lugal-e")
as.sign_name(c("d-en-lil2", "an-ki"))

## -----------------------------------------------------------------------------
dic <- read_dictionary()

## -----------------------------------------------------------------------------
look_up("lugal", dic)

## -----------------------------------------------------------------------------
look_up("d-suen", dic)

## -----------------------------------------------------------------------------
look_up("Enki", dic, "en")

## -----------------------------------------------------------------------------
look_up("an", dic)

## -----------------------------------------------------------------------------
x <- "<d-en-ki> (ki a). jal2 ((e2-kur) ra)."
skeleton(x)

## -----------------------------------------------------------------------------
fill <- guess_substr_info(x, dic)
skeleton(x, fill = fill)

## ----eval = FALSE-------------------------------------------------------------
# translate("<d-nu-dim2-mud> (ki a). jal2 ((e2-kur) ra).")

## ----eval = FALSE-------------------------------------------------------------
# result <- translate("<d-en-ki> (ki a). jal2 ((e2-kur) ra).")
# print(result)

