% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desc_var.R
\name{desc_var}
\alias{desc_var}
\title{Describe a variable, optionally by groups}
\usage{
desc_var(y, group = NULL, data = NULL, digits = 3)
}
\arguments{
\item{y}{A numeric vector of values, a column name (character string or unquoted) if \code{data} is provided,
or a formula of the form \code{y ~ x} or \code{y ~ x1 + x2} (for multiple grouping variables).}

\item{group}{Optional grouping variable, if not provided computed for the full data.
Ignored if \code{y} is a formula.}

\item{data}{Optional data frame containing the variable(s).}

\item{digits}{Number of decimal places to round to. Default is 3.}
}
\value{
A data frame with one row per group (or one row if no group is specified) containing:
  \itemize{
    \item \code{group}: Group identifier
    \item \code{mean}: Mean
    \item \code{sd}: Standard deviation
    \item \code{se}: Standard error
    \item \code{median}: Median
    \item \code{min}: Minimum
    \item \code{max}: Maximum
    \item \code{mode}: Most frequent value
    \item \code{freq_mode}: Frequency of mode
    \item \code{mode2}: 2nd most frequent value
    \item \code{freq_mode2}: Frequency of 2nd mode
    \item \code{n.total}: Number of observations
    \item \code{n.missing}: Number of observations with missing (NA) values
    \item \code{n.unique}: Number of unique values
  }
}
\description{
Returns a dataframe with one row per group
}
\examples{
# With grouping
df <- data.frame(y = rnorm(100), group = rep(c("A", "B"), 50))
desc_var(y, group, data = df)

# Without grouping (full dataset)
desc_var(y, data = df)

# Direct vectors
y <- rnorm(100)
group <- rep(c("A", "B"), 50)
desc_var(y, group)

# With custom decimal places
desc_var(y, group, data = df, digits = 2)

# Using formula syntax: y ~ x
desc_var(y ~ group, data = df)

# Using formula syntax with multiple grouping variables: y ~ x1 + x2
df2 <- data.frame(y = rnorm(200), x1 = rep(c("A", "B"), 100), x2 = rep(c("X", "Y"), each = 100))
desc_var(y ~ x1 + x2, data = df2)

}
