% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.pbcor}
\alias{ci.pbcor}
\title{Confidence intervals for point-biserial correlations}
\usage{
ci.pbcor(alpha, m1, m2, sd1, sd2, n1, n2)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{estimated mean for group 1}

\item{m2}{estimated mean for group 2}

\item{sd1}{estimated standard deviation for group 1}

\item{sd2}{estimated standard deviation for group 2}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a 2-row matrix. The columns are:
\itemize{
\item Estimate - estimated point-biserial correlation
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes confidence intervals for two types of population point-biserial
correlations. One type uses a weighted average of the group variances
and is appropriate for nonexperimental designs with simple random sampling
(but not stratified random sampling). The other type uses an unweighted
average of the group variances and is appropriate for experimental designs.
Equality of variances is not assumed for either type.

For more details, see Section 1.18 of Bonett (2021, Volume 2)
}
\examples{
ci.pbcor(.05, 28.32, 21.48, 3.81, 3.09, 40, 40)

# Should return:
#             Estimate      SE     LL     UL
# Weighted:     0.7066 0.04891 0.5885 0.7854
# Unweighted:   0.7021 0.05019 0.5808 0.7829
 

}
\references{
\insertRef{Bonett2020a}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
