% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.snreg.R
\name{vcov.snreg}
\alias{vcov.snreg}
\title{Extract the Variance-Covariance Matrix}
\usage{
\method{vcov}{snreg}(object, ...)
}
\arguments{
\item{object}{an object of class \code{"snreg"}, typically returned by \code{\link{snreg}}.}

\item{...}{additional arguments (currently unused).}
}
\value{
A numeric matrix containing the variance-covariance of the estimated parameters.
}
\description{
\code{vcov.snreg} is the \code{vcov} S3 method for objects of class \code{"snreg"}.
It returns the model-based variance-covariance matrix stored in the fitted object.
}
\details{
Variance-Covariance Matrix for snreg Objects


This method expects a fitted \code{"snreg"} object.

This method simply returns the \code{vcov} component stored in \code{object}.
If your estimator did not compute standard errors (e.g., because estimation
hasn’t been run yet in a scaffold), this field may be \code{NULL}, and the
method will error accordingly.
}
\examples{
library(snreg)

data("banks07")
head(banks07)

# Translog cost function specification

spe.tl <- log(TC) ~ (log(Y1) + log(Y2) + log(W1) + log(W2))^2 +
  I(0.5 * log(Y1)^2) + I(0.5 * log(Y2)^2) +
  I(0.5 * log(W1)^2) + I(0.5 * log(W2)^2)

# Specification 1: homoskedastic noise and skewness

# Specification 1: homoskedastic noise, skewness, inefficiency

formSV <- NULL   #' variance equation; constant variance
formSK <- NULL   #' skewness equation; constant skewness

m1 <- snreg(
  formula  = spe.tl,
  data     = banks07,
  ln.var.v = formSV,
  skew.v   = formSK
)

vcov(m1)

}
\seealso{
\code{\link{snsf}}, \code{\link{snreg}}, \code{\link{lm.mle}}, \code{\link{coef.snreg}}, \code{\link{residuals.snreg}}
}
