% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residuals.snreg.R
\name{residuals.snreg}
\alias{residuals.snreg}
\title{Residuals for snreg Objects}
\usage{
\method{residuals}{snreg}(object, esample = TRUE, ...)
}
\arguments{
\item{object}{an object of class \code{"snreg"}, typically produced by \code{\link{snreg}}.}

\item{esample}{logical. If \code{TRUE} (default), residuals are returned only for observations
used in estimation (others are \code{NA}).  
If \code{FALSE}, the raw vector of residuals (\code{obj$resid}) is returned.}

\item{...}{additional arguments (currently unused).}
}
\value{
A numeric vector of residuals.  
If \code{esample = TRUE}, the vector matches the length of the original data
and contains \code{NA} for non-estimation observations.  
If \code{esample = FALSE}, only the computed residuals are returned.
}
\description{
\code{residuals.snreg} is the S3 method for extracting residuals from a fitted
\code{snreg} model. Residuals may be returned either for the full data or only
for the estimation sample.
}
\details{
Extract Residuals from an snreg Model


This method simply accesses the \code{obj$resid} component of a fitted
\code{"snreg"} object. An informative error is produced if residuals are not
available.
}
\examples{
library(snreg)

data("banks07")
head(banks07)

# Translog cost function specification

spe.tl <- log(TC) ~ (log(Y1) + log(Y2) + log(W1) + log(W2))^2 +
  I(0.5 * log(Y1)^2) + I(0.5 * log(Y2)^2) +
  I(0.5 * log(W1)^2) + I(0.5 * log(W2)^2)

# Specification 1: homoskedastic noise and skewness

formSV <- NULL   # variance equation; constant variance
formSK <- NULL   # skewness equation; constant skewness

m1 <- snreg(
  formula  = spe.tl,
  data     = banks07,
  ln.var.v = formSV,
  skew.v   = formSK
)

residuals(m1)

}
\seealso{
\code{\link{snsf}}, \code{\link{snreg}}, \code{\link{lm.mle}}, \code{\link{vcov.snreg}}, \code{\link{coef.snreg}}
}
