% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SimIotaN}
\alias{SimIotaN}
\title{Simulate Intercept Vectors
in a Continuous-Time Vector Autoregressive Model
from the Multivariate Normal Distribution}
\usage{
SimIotaN(n, iota, vcov_iota_l)
}
\arguments{
\item{n}{Positive integer.
Number of replications.}

\item{iota}{Numeric vector.
Intercept (\eqn{\boldsymbol{\iota}}).}

\item{vcov_iota_l}{Numeric matrix.
Cholesky factorization (\code{t(chol(vcov_iota))})
of the sampling variance-covariance matrix of
\eqn{\boldsymbol{\iota}}.}
}
\value{
Returns a list of random intercept vectors.
}
\description{
This function simulates random intercept vectors
in a continuous-time vector autoregressive model
from the multivariate normal distribution.
}
\examples{
n <- 10
iota <- c(0, 0, 0)
vcov_iota_l <- t(chol(0.001 * diag(3)))
SimIotaN(n = n, iota = iota, vcov_iota_l = vcov_iota_l)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMInterceptEta}()},
\code{\link{SSMInterceptY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimBetaNCovariate}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimPhiNCovariate}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{simStateSpace}
\keyword{ssm}
