#' @title Sample Dataset: Simple Mediation
#'
#' @description A simple mediation model.
#'
#' @format A data frame with 100 rows and 5 variables:
#' \describe{
#'   \item{x}{Predictor. Numeric.}
#'   \item{m}{Mediator. Numeric.}
#'   \item{y}{Outcome variable. Numeric.}
#'   \item{city}{Group variable: "City A" or "City B". String.}
#' }
#'
#' @examples
#' library(lavaan)
#' data(simple_mediation)
#' mod <-
#' "
#' m ~ a * x
#' y ~ b * m + x
#' ab := a * b
#' "
#' fit <- sem(mod, simple_mediation, fixed.x = FALSE)
#' parameterEstimates(fit)
#' mod_gp <-
#' "
#' m ~ c(a1, a2) * x
#' y ~ c(b1, b2) * m + x
#' a1b1 := a1 * b1
#' a2b2 := a2 * b2
#' ab_diff := a1b1 - a2b2
#' "
#' fit_gp <- sem(mod_gp, simple_mediation, fixed.x = FALSE, group = "city")
#' parameterEstimates(fit_gp)
"simple_mediation"