% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scplot.sc_hplm.R
\name{scplot.sc_hplm}
\alias{scplot.sc_hplm}
\title{Forest Plot for Random Effects of Mixed HPLM Models}
\usage{
\method{scplot}{sc_hplm}(object, effect = "intercept", mark = "fixed", ci = 0.95, ...)
}
\arguments{
\item{object}{The return from the \code{hplm()} function.}

\item{effect}{The specific effect to be plotted (default is the intercept).}

\item{mark}{Set a reference line.}

\item{ci}{Value between 0 and 1 for calculating the confidence interval.}

\item{...}{Further arguments.}
}
\value{
A forest plot displaying Tau-U effects.
}
\description{
This function generates a forest plot for the random effects of a mixed hplm
model.
}
\examples{
model <- scan::hplm(scan::Leidig2018, random.slopes = TRUE)
scplot(model, effect = "level")

}
