% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANOVA_DCt.r
\name{ANOVA_DCt}
\alias{ANOVA_DCt}
\title{Delta Ct ANOVA analysis}
\usage{
ANOVA_DCt(
  x,
  numOfFactors,
  numberOfrefGenes,
  block,
  alpha = 0.05,
  p.adj = "none",
  analyseAllTarget = TRUE
)
}
\arguments{
\item{x}{A data frame containing experimental design columns, target gene
E/Ct column pairs, and reference gene E/Ct column pairs. Reference gene
columns must be located at the end of the data frame.}

\item{numOfFactors}{Integer. Number of experimental factor columns
(excluding \code{rep} and optional \code{block}).}

\item{numberOfrefGenes}{Integer. Number of reference genes. Each reference gene
must be represented by two columns (E and Ct).}

\item{block}{Character or \code{NULL}. Name of the blocking factor column.
When a qPCR experiment is done in multiple qPCR plates, 
variation resulting from the plates may interfere with the actual amount of 
gene expression. One solution is to conduct each plate as a randomized block 
so that at least one replicate of each treatment and control is present 
on a plate. Block effect is usually considered as random and its interaction 
with any main effect is not considered.}

\item{alpha}{statistical level for comparisons}

\item{p.adj}{Method for p-value adjustment. See \code{\link[stats]{p.adjust}}.}

\item{analyseAllTarget}{Logical or character.
If \code{TRUE} (default), all detected target genes are analysed.
Alternatively, a character vector specifying the names (names of their Efficiency columns) of target genes
to be analysed.}
}
\value{
An object containing expression table, lm models, ANOVA tables, residuals, raw data and ANOVA table for each gene. 
\describe{
\item{\eqn{\Delta C_T} combined expression table}{\code{object$combinedResults}}
\item{ANOVA table for treatments}{\code{object$perGene$gene_name$ANOVA_T}}
\item{ANOVA table factorial}{\code{object$perGene$gene_name$ANOVA_factorial}}
\item{lm ANOVA for tratments}{\code{object$perGene$gene_name$lm_T}}
\item{lm ANOVA factorial}{\code{object$perGene$gene_name$lm_factorial}}
\item{Residuals}{\code{resid(object$perGene$gene_name$lm_T)}}
}
}
\description{
Performs \eqn{\Delta C_T} analysis for target genes by
applying \eqn{\Delta C_T} method to each target gene. Target genes must be provided as paired
efficiency (E) and Ct columns followed by the the reference gene(s) columns. 
See "Input data structure and column arrangement" in vignettes for details about data structure.
}
\examples{
data <- read.csv(system.file("extdata", "data_3factor.csv", package = "rtpcr"))
res <- ANOVA_DCt(
  data,
  numOfFactors = 3,
  numberOfrefGenes = 1,
  block = NULL)
}
