% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqlStatement.R
\name{sqlStatement}
\alias{sqlStatement}
\title{Construct an SQLite query}
\usage{
sqlStatement(
  groupBy = NULL,
  aggregate = NULL,
  aggregateFunction = "SUM",
  where = NULL
)
}
\arguments{
\item{groupBy}{character string or vector of these. Vector of variables
(column names) to \code{GROUP BY} (optional)}

\item{aggregate}{character string of vector of these. Vector of variables
(column names) to aggregate using \code{aggregateFunction} (optional)}

\item{aggregateFunction}{character string. An SQL aggregate function
(e.g. \code{SUM}, \code{COUNT}). Default is \code{SUM}}

\item{where}{named list. A list of subset variables. Names are column names,
and elements are the values to be selected from each column (optional)}
}
\value{
Returns a list of \code{SELECT}, \code{GROUP BY} and \code{WHERE} SQL statements used by the
\code{\link{datasheet}} function to construct an SQLite database query.
}
\description{
Creates \code{SELECT}, \code{GROUP BY} and \code{WHERE} SQL statements.
The resulting list of SQL statements will be converted to an SQLite database
query by the \code{\link{datasheet}} function.
}
\details{
Variables are column names of the Datasheet. See column names using \code{datasheet(,empty=TRUE)}
Variables not included in \code{groupBy}, \code{aggregate} or \code{where} will be dropped from the table.
Note that it is not possible to construct a complete SQL query at this stage,
because the \code{\link{datasheet}} function may add ScenarioId and/or ProjectId to the query.
}
\examples{
\dontrun{
# Query total Amount for each combination of ScenarioId, Iteration, Timestep and StateLabelXID,
# including only Timesteps 0,1 and 2, and Iterations 3 and 4.
mySQL <- sqlStatement(
  groupBy = c("ScenarioId", "Iteration", "Timestep"),
  aggregate = c("yCum"),
  aggregateFunction = "SUM",
  where = list(Timestep = c(0, 1, 2), Iteration = c(3, 4))
)
mySQL
}
\dontrun{
# The SQL statement can then be used in the datasheet function

# Set the file path and name of an existing SsimLibrary
myLibraryName <- file.path("MyLibrary.ssim")

# Set the SyncroSim Session, SsimLibrary, Project, and Scenario
mySession <- session()
myLibrary <- ssimLibrary(name = myLibraryName,
                         session = mySession)
myProject <- project(myLibrary, project = "Definitions")
myScenario <- scenario(myProject, scenario = "My Scenario")

# Run Scenario to generate results
resultScenario <- run(myScenario)

# Use the SQL statement when loading the Datasheet
myAggregatedDataFrame <- datasheet(resultScenario, 
                                   name = "helloworldSpatial_OutputDatasheet",
                                   sqlStatement = mySQL)
                                   
# View aggregated DataFrame
myAggregatedDataFrame
}

}
