% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jd3txt.R
\name{txt_properties_to_id}
\alias{txt_properties_to_id}
\title{Generates the id corresponding to a list of a text properties.}
\usage{
txt_properties_to_id(props)
}
\arguments{
\item{props}{The properties defining the identifier.}
}
\value{
The identifier corresponding to the properties.
}
\description{
Generates the id corresponding to a list of a text properties.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
\donttest{
set_txt_paths(system.file("extdata", package = "rjd3providers"))
txt_15 <- txt_series("ABS.csv", series = 15, delimiter = "COMMA")
id<-txt_15$moniker$id
source<-txt_name()
props<-txt_id_to_properties(id)
props$gathering$period<-4
props$gathering$aggregation<-"Max"
M<-rjd3toolkit::to_ts(txt_name(), txt_properties_to_id(props))
props$gathering$aggregation<-"Min"
m<-rjd3toolkit::to_ts(txt_name(), txt_properties_to_id(props))
ts.plot(ts.union(M$data,m$data), col=c("red", "blue"))
}
\dontshow{\}) # examplesIf}
}
