% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{gd_initialize}
\alias{gd_initialize}
\alias{gd_is_initialized}
\title{Initialize \code{geedim}}
\usage{
gd_initialize(
  private_key_file = NULL,
  credentials = NULL,
  cloud_api_key = NULL,
  url = "https://earthengine-highvolume.googleapis.com",
  http_transport = NULL,
  project = NULL,
  quiet = FALSE
)

gd_is_initialized(..., quiet = TRUE)
}
\arguments{
\item{private_key_file}{character. Optional: Path to JSON file containing service account credentials. (Deprecated in v0.3.0: use \code{GOOGLE_APPLICATION_CREDENTIALS} environment variable instead. If provided and \code{GOOGLE_APPLICATION_CREDENTIALS} is not set, the file path will be used to set that environment variable.)}

\item{credentials}{Default: \code{NULL} uses Google Application Default Credentials (ADC) to find credentials automatically. Can be set to a pre-existing credential object if needed.}

\item{cloud_api_key}{An optional API key to use the Cloud API. Default: \code{NULL}.}

\item{url}{The base url for the EarthEngine REST API to connect to. Defaults to "High Volume" endpoint: \code{"https://earthengine-highvolume.googleapis.com"}}

\item{http_transport}{The HTTP transport method to use when making requests. Default: \code{NULL}}

\item{project}{The client project ID or number to use when making API calls. Default: \code{NULL} will check \code{GOOGLE_CLOUD_QUOTA_PROJECT}, \code{GOOGLE_CLOUD_PROJECT} then \code{GCLOUD_PROJECT} environment variables.}

\item{quiet}{Suppress error messages? Default: \code{TRUE}}

\item{...}{Additional arguments passed to \code{gd_initialize()}}
}
\value{
\code{gd_initialize()}: try-error (invisibly) on error.

\code{gd_is_initialized()}: logical. \code{TRUE} if initialized successfully.
}
\description{
Calls \code{geedim} \code{Initialize()} method. This method should be called at the beginning of each session.
}
\details{
Authentication is handled automatically by Google Application Default Credentials (ADC). When \code{credentials} is \code{NULL} (the default), the underlying Python libraries will automatically search for credentials in the following order:
\enumerate{
\item \code{GOOGLE_APPLICATION_CREDENTIALS} environment variable (if set)
\item User credentials from \verb{gcloud auth application-default login}
\item Attached service account (when running on Google Cloud infrastructure)
}

In a headless environment (e.g. CI/CD), use \code{GOOGLE_APPLICATION_CREDENTIALS} to specify the service account key file path and \code{GOOGLE_CLOUD_QUOTA_PROJECT} to specify the project ID responsible for quota and billing.

The deprecated \code{private_key_file} parameter is provided for backward compatibility. If specified and \code{GOOGLE_APPLICATION_CREDENTIALS} is not already set, the file path will be used to set that environment variable for the Python libraries to discover.
}
\examples{
\dontrun{
gd_initialize()
}
gd_is_initialized()
}
\seealso{
\code{gd_authenticate()}
}
