% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk_nopolyline.R
\name{chk_nopolyline}
\alias{chk_nopolyline}
\alias{chk_nopolyline.actframe}
\title{Remove activities with no geographic data}
\usage{
chk_nopolyline(act_data, ...)

\method{chk_nopolyline}{actframe}(act_data, ...)
}
\arguments{
\item{act_data}{a \code{data.frame} returned by \code{\link{compile_activities}}}

\item{...}{arguments passed to or from other methods}
}
\value{
\code{act_data} with rows removed where no polylines were available, the original dataseset is returned if none were found. A warning is also returned indicating the row numbers that were removed if applicable.
}
\description{
Remove activities with no geographic data, usually manual entries
}
\details{
This function is used internally within \code{\link{get_elev_prof}} and \code{\link{get_heat_map}} to remove activities that cannot be plotted because they have no geographic information.  This usually applies to activities that were manually entered.
}
\examples{
\dontrun{
# get my activities
stoken <- httr::config(token = strava_oauth(app_name, app_client_id, app_secret, cache = TRUE))
my_acts <- get_activity_list(stoken)
act_data <- compile_activities(my_acts)
chk_nopolyline(act_data)
}
}
\author{
Marcus Beck
}
\concept{token}
