% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_winprogressbar.R
\name{handler_winprogressbar}
\alias{handler_winprogressbar}
\title{Progression Handler: Progress Reported as a MS Windows Progress Bars in the GUI}
\usage{
handler_winprogressbar(
  intrusiveness = getOption("progressr.intrusiveness.gui", 1),
  target = "gui",
  inputs = list(title = NULL, label = "message"),
  ...
)
}
\arguments{
\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{inputs}{(named list) Specifies from what sources the MS Windows
progress elements 'title' and 'label' should be updated. Valid sources are
\code{"message"}, \code{"sticky_message"} and \code{"non_sticky_message"}, where
\code{"message"} is short for \code{c("non_sticky_message", "sticky_message")}. For
example, \code{inputs = list(title = "sticky_message", label = "message")}
will update the 'title' component from sticky messages only,
whereas the 'label' component is updated using any message.}

\item{\ldots}{Additional arguments passed to \code{tcltk::winProgressBar()}
and \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
A progression handler for \code{winProgressBar()} in the \pkg{utils} package.
}
\section{Requirements}{

This progression handler requires MS Windows.
}

\examples{
\donttest{\dontrun{
handlers(handler_winprogressbar())
with_progress(y <- slow_sum(1:100))
}}

}
