% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handler_slowdown.R
\name{handler_slowdown}
\alias{handler_slowdown}
\title{Progression Handler: Slow Down Progress Reporting}
\usage{
handler_slowdown(
  duration = 10,
  intrusiveness = 0,
  target = "void",
  enable = getOption("progressr.enable", TRUE),
  ...
)
}
\arguments{
\item{duration}{(numeric) Added slowdown (in seconds) across all progress
steps, e.g. if \code{duration = 10.0} and \code{steps = 100L}, then each step unit is
delayed 0.1 seconds, totaling a ten-second slowdown.}

\item{intrusiveness}{(numeric) A non-negative scalar on how intrusive
(disruptive) the reporter to the user.}

\item{target}{(character vector) Specifies where progression updates are
rendered.}

\item{enable}{(logical) If FALSE, then progress is not reported.}

\item{\ldots}{Additional arguments passed to \code{\link[=make_progression_handler]{make_progression_handler()}}.}
}
\description{
Progression Handler: Slow Down Progress Reporting
}
\details{
This progression handler delays each progress step a certain number of
seconds. It does not render any output.
}
\examples{
\donttest{\dontrun{
handlers(handler_slowdown(duration = 30.0)) ## 30-second total slowdown
with_progress(y <- slow_sum(1:100))
print(y)
}}

}
