% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_handlers.R
\name{api_redirect}
\alias{api_redirect}
\title{Redirect request to another resource}
\usage{
api_redirect(api, method, from, to, permanent = TRUE)
}
\arguments{
\item{api}{A plumber2 api object to add the redirect to}

\item{method}{The HTTP method the redirect should respond to}

\item{from}{The path the redirect should respond to}

\item{to}{The path/URL to redirect the incoming request towards. After
resolving any path parameters and wildcards it will be used in the
\code{Location} header}

\item{permanent}{Logical. Is the redirect considered permanent or
temporary? Determines the type of redirect status code to use}
}
\value{
This functions return the \code{api} object allowing for easy chaining
with the pipe
}
\description{
While it is optimal that an API remains stable over its lifetime it is often
not fully attainable. In order to direct requests for resources that has
been moved to the new location you can add a redirect that ensures a smooth
transition for clients still using the old path. Depending on the value
of \code{permanent} the redirect will respond with a \verb{307 Temporary Redirect} or
\verb{308 Permanent Redirect}. \code{from} and \code{to} can contain path parameters and
wildcards which will be matched between the two to construct the correct
redirect path. Further, \code{to} can either be a path to the same server or a
fully qualified URL to redirect requests to another server altogether.
}
\section{Using annotation}{
You can specify redirects in an annotated plumber file using the \verb{@redirect}
tag. Precede the method with a \code{!} to mark the redirect as permanent

\if{html}{\out{<div class="sourceCode">}}\preformatted{#* @redirect !get /old/data/* /new/data/*
#* @redirect any /unstable/endpoint /stable/endpoint
NULL
}\if{html}{\out{</div>}}
}

\examples{
api() |>
  api_redirect("get", "/old/data/*", "/new/data/*")

}
