% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_logger.R
\docType{data}
\name{api_logger}
\alias{api_logger}
\alias{logger_null}
\alias{logger_console}
\alias{logger_file}
\alias{logger_logger}
\alias{logger_otel}
\alias{logger_switch}
\alias{common_log_format}
\alias{combined_log_format}
\title{Set logging function and access log format for the API}
\usage{
api_logger(api, logger = NULL, access_log_format = NULL)

logger_null()

logger_console(format = "{time} - {event}: {message}")

logger_file(file, format = "{time} - {event}: {message}")

logger_logger(default_level = "INFO")

logger_otel(format = "{message}")

logger_switch(..., default = logger_null())

common_log_format

combined_log_format
}
\arguments{
\item{api}{A plumber2 api object to set the logger on}

\item{logger}{A logger function. If \code{NULL} then the current logger is kept}

\item{access_log_format}{A glue string giving the format for the access logs.
plumber2 (through fiery) provides the predefined \code{common_log_format} and
\code{combined_log_format}, but you can easily create your own. See
\link[fiery:loggers]{fiery::loggers} for which variables the glue string has access to.}

\item{format}{A \link[glue:glue]{glue}-like string specifying the format of the
log entry. Only the variables \code{time}, \code{event}, and \code{message} are available
and must be given verbatim}

\item{file}{A file or connection to write to}

\item{default_level}{The log level to use for events that are not \code{request},
\code{websocket}, \code{message}, \code{warning}, or \code{error}}

\item{...}{A named list of loggers to use for different events. The same
semantics as \link[base:switch]{switch} is used so it is possible to let events
\emph{fall through} e.g. \code{logger_switch(error =, warning = logger_file('errors.log'))}.}

\item{default}{A catch-all logger for use with events not defined in \code{...}}
}
\description{
plumber2 has a build-in logging facility that takes care of logging any
conditions that are caught, as well as access logs. Further it is possible to
log custom messages using the \code{log()} method on the api object. However, the
actual logging is handled by a customizable function that can be set. You can
read more about the logging infrastructure in the
\link[fiery:loggers]{fiery documentation}. plumber2 reexports the loggers
provided by fiery so they are immediately available to the user.
}
\section{Using annotation}{
Logger setup doesn't have a dedicated annotation tag, but you can set it up
in a \verb{@plumber} block

\if{html}{\out{<div class="sourceCode">}}\preformatted{#* @plumber
function(api) \{
  api |>
    api_logger(logger = logger_null())
\}
}\if{html}{\out{</div>}}
}

\examples{
# Use a different access log format
api() |>
  api_logger(access_log_format = combined_log_format)

# Turn off logging
api() |>
  api_logger(logger_null())


}
\keyword{datasets}
