% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{demo_const_dmd}
\alias{demo_const_dmd}
\title{demo_const_dmd}
\format{
A data frame with 144 rows and 5 variables
}
\usage{
data(demo_const_dmd)
}
\description{
This dataset contains the basic features to calculate projected inventories and coverages.
Just 5 features are needed for this: a DFU, a Period, a Demand, an initial Opening Inventory and a Supply Plan.
The idea is to use this dataset to calculate a constrained demand for each Product, on top of the projected inventories & coverages.
A constrained demand is a possible demand, which can be answered considering the projected inventories.
Then we can apply on this dataset the const_dmd() function, it will add 2 variables : a Constrained.Demand and a Current.Stock.Available.Tag .
The Constrained.Demand is the Demand which can be answered considering the projected inventories, i.e which quantity can be answered and when it can be answered.
The Current.Stock.Available.Tag informs the part of the Demand which is already covered by the Opening Inventories.
}
\details{
\itemize{
\item DFU, an item
\item Period, a date
\item Demand, a consumption in units
\item Opening, available inventories at the beginning in units
\item Supply, a Replenishment Plan in units

}
}
\author{
Nicolas Nguyen \email{nikonguyen@yahoo.fr}
}
