% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rtaxonkit.R
\name{taxonkit_lineage}
\alias{taxonkit_lineage}
\title{Retrieve Taxonomic Lineage using taxonkit}
\usage{
taxonkit_lineage(
  file_path,
  delimiter = ";",
  no_lineage = FALSE,
  show_lineage_ranks = FALSE,
  show_lineage_taxids = FALSE,
  show_name = FALSE,
  show_rank = FALSE,
  show_status_code = FALSE,
  taxid_field = 1,
  text = FALSE,
  data_dir = NULL
)
}
\arguments{
\item{file_path}{The path to the input file with taxonomic IDs. Or file text (text=TRUE)}

\item{delimiter}{The field delimiter in the lineage (default ";").}

\item{no_lineage}{Logical, indicating whether to exclude lineage information (default: FALSE).}

\item{show_lineage_ranks}{Logical, indicating whether to append ranks of all levels in the lineage (default: FALSE).}

\item{show_lineage_taxids}{Logical, indicating whether to append lineage consisting of taxids (default: FALSE).}

\item{show_name}{Logical, indicating whether to append scientific name (default: FALSE).}

\item{show_rank}{Logical, indicating whether to append rank of taxids (default: FALSE).}

\item{show_status_code}{Logical, indicating whether to show status code before lineage (default: FALSE).}

\item{taxid_field}{The field index of taxid. Input data should be tab-separated (default: 1).}

\item{text}{logical,}

\item{data_dir}{directory containing nodes.dmp and names.dmp (default "/Users/asa/.taxonkit")}
}
\value{
A character vector containing the taxonomic lineage information.
}
\description{
Retrieve Taxonomic Lineage using taxonkit
}
\examples{
\dontrun{
taxonkit_lineage("9606\n63221", show_name = TRUE, show_rank = TRUE, text = TRUE)
}
}
\seealso{
Other Rtaxonkit: 
\code{\link{check_taxonkit}()},
\code{\link{download_taxonkit_dataset}()},
\code{\link{install_taxonkit}()},
\code{\link{name_or_id2df}()},
\code{\link{taxonkit_filter}()},
\code{\link{taxonkit_lca}()},
\code{\link{taxonkit_list}()},
\code{\link{taxonkit_name2taxid}()},
\code{\link{taxonkit_reformat}()}
}
\concept{Rtaxonkit}
