% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-record.R
\name{orcid_fetch_record}
\alias{orcid_fetch_record}
\title{Retrieve complete ORCID record}
\usage{
orcid_fetch_record(
  orcid_id,
  token = NULL,
  sections = c("employments", "educations", "works", "funding", "peer-reviews")
)
}
\arguments{
\item{orcid_id}{Character string. A valid ORCID identifier in the format
XXXX-XXXX-XXXX-XXXX. Can also handle URLs like https://orcid.org/XXXX-XXXX-XXXX-XXXX.}

\item{token}{Character string or NULL. Optional API token for authenticated
requests. If NULL (default), checks the ORCID_TOKEN environment variable.
Most public data is accessible without authentication.}

\item{sections}{Character vector. Sections to fetch. Default is the most
commonly used sections: c("employments", "educations", "works", "funding",
"peer-reviews"). Available sections are:
\itemize{
\item Affiliations: "employments", "educations", "distinctions",
"invited-positions", "memberships", "qualifications", "services",
"research-resources"
\item Activities: "works", "funding", "peer-reviews"
\item Biographical: "person", "bio", "keywords", "researcher-urls",
"external-identifiers", "other-names", "address", "email"
}
You can specify a subset to fetch only specific sections.}
}
\value{
A named list with the following possible elements (each a data.table):
\describe{
\item{employments}{Employment history}
\item{educations}{Education history}
\item{distinctions}{Distinctions and honors}
\item{invited_positions}{Invited positions}
\item{memberships}{Professional memberships}
\item{qualifications}{Qualifications}
\item{services}{Service activities}
\item{research_resources}{Research resources}
\item{works}{Works/publications}
\item{funding}{Funding records}
\item{peer_reviews}{Peer review activities}
\item{person}{Complete person data}
\item{bio}{Biography}
\item{keywords}{Keywords}
\item{researcher_urls}{Researcher URLs}
\item{external_identifiers}{External identifiers}
\item{other_names}{Other names}
\item{address}{Address information}
\item{email}{Email addresses}
}
Empty data.tables are returned for sections with no data.
}
\description{
Fetches all public data for a given ORCID identifier, including employments,
education, works, funding, and peer reviews. Returns a named list of
data.table objects.
}
\details{
This is a convenience function that calls individual API functions for each
section. Each section requires a separate API request.

To minimize API calls, specify only the sections you need using the
\code{sections} parameter.
}
\examples{
\dontrun{
# Fetch complete record for a public ORCID
record <- orcid_fetch_record("0000-0002-1825-0097")
names(record)
record$works
record$employments

# Fetch only works and funding
record <- orcid_fetch_record(
  "0000-0002-1825-0097",
  sections = c("works", "funding")
)

# With authentication
Sys.setenv(ORCID_TOKEN = "your-token-here")
record <- orcid_fetch_record("0000-0002-1825-0097")
}

}
\references{
ORCID API Documentation: \url{https://info.orcid.org/documentation/api-tutorials/}
}
\seealso{
\code{\link{orcid_fetch_many}}, \code{\link{orcid_employments}}, \code{\link{orcid_works}}
}
