% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-tee.R
\name{tee}
\alias{tee}
\title{Tee a pipeline to extract the data at a given point}
\usage{
tee(x, .name = "teeout", .env = NULL)
}
\arguments{
\item{x}{The data coming in (whatever it may be).}

\item{.name}{The name to assign to the output within \code{.env}.}

\item{.env}{The environment within which to save the output at this point. Defaults to the caller env (i.e the env which the pipeline is in).}
}
\value{
The value that came from the left hand side of the pipe.
}
\description{
Add a tee to a pipeline to get the data coming in through the pipe.

This is generally a useful function for debugging pipelines, and for caching
data after expensive calls. It is also useful if you want the flexibility of
multiple calls with the convenience of a fully-piped approach.

The name \code{tee} comes from the \href{https://man7.org/linux/man-pages/man1/tee.1.html}{\code{tee}} shell command within unix systems.
}
\note{
\code{\link[=tee]{tee()}} does modify the external environment (if \code{.env} is not specified).
This can lead to unpredictable behaviour if not carefully managed, so it is generally
worthwhile restricting usage to interactive situations where the environment
can be more carefully monitored.
}
\examples{
pipeout <- 1:5 |> exp() |> tee("teeout") |> log()
print(pipeout)
print(teeout)

myenv <- new.env()
pipeout <- 1:5 |> exp() |> tee("teeout", .env = myenv) |> log()
print(myenv$teeout)
}
\author{
Francis Windram
}
