% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-validation.R
\name{match_countries}
\alias{match_countries}
\title{Match country names to their equivalent naturalearth WKT polygons}
\usage{
match_countries(countrynames, returnmulti = TRUE, onlywkt = FALSE)
}
\arguments{
\item{countrynames}{a vector of country names to match to naturalearth.}

\item{returnmulti}{return the GBIF taxon ids only (otherwise return the full lookup dataframe).}

\item{onlywkt}{only return location_wkt (see note for more details).}
}
\value{
A list containing:
\itemize{
\item \verb{$location_wkt}: a multipolygon containing all locations (or a named vector of individual country polygons).
\item \verb{$missing_locs}: any provided countries not found in naturalearth.
\item \verb{$found_locs}: any provided countries that were found in naturalearth.
}
}
\description{
Match country names to their equivalent naturalearth WKT polygons using \code{\link[rnaturalearth:ne_countries]{rnaturalearth::ne_countries()}}.
}
\examples{
match_countries(c("United Kingdom", "Germany"))

}
\author{
Francis Windram
}
\concept{convenience}
