% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_vt.R
\name{fetch_vt}
\alias{fetch_vt}
\title{Fetch VecTraits dataset/s by ID}
\usage{
fetch_vt(ids, rate = 5, connections = 2, basereq = vb_basereq())
}
\arguments{
\item{ids}{a numeric ID or numeric vector of ids (preferably in an \code{ohvbd.ids} object) indicating the particular dataset/s to download.}

\item{rate}{maximum number of calls to the API per second.}

\item{connections}{number of simultaneous connections to the server at once. Maximum 8. \strong{Do not enable unless you really need to} as this hits the server significantly harder than usual.}

\item{basereq}{an \link[httr2:request]{httr2 request} object, as generated by \code{\link[=vb_basereq]{vb_basereq()}}. If \code{NA}, uses the default request.}
}
\value{
A list of \link[httr2:response]{httr2 response} objects, as an \code{ohvbd.responses} object.
}
\description{
Retrieve VecTraits dataset/s specified by their dataset ID.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
fetch_vt(54)

fetch_vt(c(54, 55, 56))

ohvbd.ids(c(54, 55, 56), "vt") |>
  fetch() # Calls fetch_vt()
\dontshow{\}) # examplesIf}
}
\author{
Francis Windram
}
\concept{vectraits}
