#' @title Get current IDs in VecTraits
#' @description Get all the current dataset IDs in VecTraits, as a numeric vector.
#' @author Francis Windram
#'
#' @param basereq an [httr2 request][httr2::request()] object, as generated by [vb_basereq()]. If `NA`, uses the default request.
#' @return An `ohvbd.ids` vector of VecTraits dataset IDs.
#'
#' @examplesIf interactive()
#' find_vt_ids()
#'
#' @concept vectraits
#'
#' @export
#'

find_vt_ids <- function(basereq = vb_basereq()) {

  resplist <- tryCatch(
    {
      resp <- basereq |>
        req_url_path_append("vectraits-explorer") |>
        req_url_query("format" = "json") |>
        req_perform()
      list("resp" = resp, "err_code" = 0, "err_obj" = NULL)
    },
    error = function(e) {
      # Get the last response instead
      list("resp" = last_response(), "err_code" = 1, "err_obj" = e)
    }
  )

  if (resplist$err_code == 1) {
    cli::cli_abort("No records found.")
  }

  body <- resplist$resp |> resp_body_json()
  outids <- as.numeric(body$ids)
  outids <- new_ohvbd.ids(v = outids, db = "vt")
  return(outids)
}
