% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reverse_geo_lite.R
\name{reverse_geo_lite}
\alias{reverse_geo_lite}
\title{Reverse geocoding API}
\usage{
reverse_geo_lite(
  lat,
  long,
  address = "address",
  full_results = FALSE,
  return_coords = TRUE,
  verbose = FALSE,
  nominatim_server = "https://nominatim.openstreetmap.org/",
  progressbar = TRUE,
  custom_query = list()
)
}
\arguments{
\item{lat}{Latitude values in numeric format. Must be in the range
\eqn{\left[-90, 90 \right]}.}

\item{long}{Longitude values in numeric format. Must be in the range
\eqn{\left[-180, 180 \right]}.}

\item{address}{Address column name in the output data (default  \code{"address"}).}

\item{full_results}{Returns all available data from the API service.
If \code{FALSE} (default) only latitude, longitude and address columns are
returned. See also \code{return_addresses}.}

\item{return_coords}{Return input coordinates with results if \code{TRUE}.}

\item{verbose}{If \code{TRUE} then detailed logs are output to the console.}

\item{nominatim_server}{The URL of the Nominatim server to use.
Defaults to \code{"https://nominatim.openstreetmap.org/"}.}

\item{progressbar}{Logical. If \code{TRUE} displays a progress bar to indicate
the progress of the function.}

\item{custom_query}{API-specific parameters to be used, passed as a named
list (ie. \code{list(zoom = 3)}). See \strong{Details}.}
}
\value{
A \code{\link[tibble:tibble]{tibble}} with the results found by the query.
}
\description{
Generates an address from a latitude and longitude. Latitudes must be
between \eqn{\left[-90, 90 \right]} and longitudes between
\eqn{\left[-180, 180 \right]}. This function returns the
\code{\link[tibble:tibble]{tibble}} associated with the query, see
\code{\link[=reverse_geo_lite_sf]{reverse_geo_lite_sf()}} for retrieving the data as a spatial object
(\code{\link[sf:sf]{sf}} format).
}
\details{
See \url{https://nominatim.org/release-docs/develop/api/Reverse/} for additional
parameters to be passed to \code{custom_query}.
}
\section{About Zooming}{


Use the option \code{custom_query = list(zoom = 3)} to adjust the output. Some
equivalences on terms of zoom:\tabular{ll}{
   \strong{zoom} \tab \strong{address_detail} \cr
   \code{3} \tab country \cr
   \code{5} \tab state \cr
   \code{8} \tab county \cr
   \code{10} \tab city \cr
   \code{14} \tab suburb \cr
   \code{16} \tab major streets \cr
   \code{17} \tab major and minor streets \cr
   \code{18} \tab building \cr
}
}

\examples{
\dontshow{if (nominatim_check_access()) withAutoprint(\{ # examplesIf}
\donttest{

reverse_geo_lite(lat = 40.75728, long = -73.98586)

# Several coordinates
reverse_geo_lite(lat = c(40.75728, 55.95335), long = c(-73.98586, -3.188375))

# With options: zoom to country level
sev <- reverse_geo_lite(
  lat = c(40.75728, 55.95335), long = c(-73.98586, -3.188375),
  custom_query = list(zoom = 0, extratags = TRUE),
  verbose = TRUE, full_results = TRUE
)

dplyr::glimpse(sev)
}
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=reverse_geo_lite_sf]{reverse_geo_lite_sf()}}, \code{\link[tidygeocoder:reverse_geo]{tidygeocoder::reverse_geo()}}.

Reverse geocoding coordinates:
\code{\link{reverse_geo_lite_sf}()}
}
\concept{reverse}
