% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validString.R
\name{validStringcat}
\alias{validStringcat}
\title{Validate and correct model string for ACO/TS}
\usage{
validStringcat(string, search.space = "ivbase", custom_config = NULL)
}
\arguments{
\item{string}{Numeric vector representing categorical model encoding.}

\item{search.space}{Character string specifying which search space to use.
Options are "ivbase", "oralbase", or "custom". Default is "ivbase".}

\item{custom_config}{List, configuration for custom search spaces. Required
when search.space is "custom".}
}
\value{
Numeric vector of validated and corrected parameters (categorical).
}
\description{
Validates model parameter strings from ACO or tabu search algorithms.
}
\details{
The input string is interpreted using the parameter order defined by the
selected search space configuration (for "custom", this is custom_config$params).
The function:
\enumerate{
\item Maps the input vector to named parameters via parseParams().
\item Enforces model constraints via applyParamDeps().
\item Returns only the parameters that belong to the search space, using
the same order as space_cfg$params.
}
This design ensures the returned vector is compatible with downstream model
generation and with binary encoding wrappers (for example, validStringbinary()).
}
\examples{
# Example 1: ivbase, 1 compartment disables peripheral terms.
invalid_iv <- c(1, 1, 1, 1, 0, 1, 0, 0, 0, 1)
validStringcat(invalid_iv, "ivbase")

# Example 2: oralbase, mm = 0 forces eta.km to 0.
invalid_oral <- c(2, 1, 1, 0, 0, 0, 0, 1, 0, 0, 1)
validStringcat(invalid_oral, "oralbase")

# Example 3: custom, mcorr is cleared when there are not enough IIV terms.
simple_config <- list(
  route = "bolus",
  params = c("eta.vc", "mcorr", "rv"),
  param_dependencies = list(),
  fixed_params = list(no.cmpt = 1, eta.cl = 1, allometric_scaling = 1)
)
invalid_custom <- c(0, 1, 4)
validStringcat(invalid_custom, "custom", custom_config = simple_config)

}
\seealso{
\code{\link{validStringbinary}} for the GA wrapper using binary encoding.
\code{\link{parseParams}} for mapping vectors to named parameters.
\code{\link{applyParamDeps}} for constraint enforcement rules.
}
\author{
Zhonghui Huang
}
