% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabu.operator.R
\name{tabuControl}
\alias{tabuControl}
\title{Control Parameters for Tabu Search}
\usage{
tabuControl(
  tenure = 3,
  niter = 20,
  aspiration = TRUE,
  nsize = NULL,
  policy = "attribute"
)
}
\arguments{
\item{tenure}{Integer. Number of iterations a move remains tabu.}

\item{niter}{Integer. Maximum number of search iterations.}

\item{aspiration}{Logical. Whether to apply the aspiration criterion.
If TRUE, tabu moves are allowed if they yield a solution strictly better
than the global best found so far.}

\item{nsize}{Optional integer. If not NULL, restricts neighborhood sear
to a random subset of this size (candidate list strategy).}

\item{policy}{Character. Type of tabu restriction:
\itemize{
\item \code{"attribute"} — forbid revisiting a variable value (default).
\item \code{"move"} — forbid only specific from–to transitions.
}}
}
\value{
A named list containing all tabu control parameters.
}
\description{
Creates a list of control settings for the \code{tabu.operator} function.
}
\examples{
tabuControl()

}
\author{
Zhonghui Huang
}
